/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.renderer.ShortcutLinkConfig;
import com.atlassian.confluence.renderer.ShortcutLinksManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public class ShortcutLinksUpgradeTask
implements UpgradeTask {
    public String getBuildNumber() {
        return "110";
    }

    public String getShortDescription() {
        return "Copy shortcut links into new bandana-configuration file";
    }

    public void doUpgrade() throws Exception {
        BootstrapManager bootstrapManager = (BootstrapManager)ContainerManager.getComponent((String)"bootstrapManager");
        ShortcutLinksManager shortcutLinksManager = (ShortcutLinksManager)ContainerManager.getComponent((String)"shortcutLinksManager");
        File shortcutPropFile = new File(bootstrapManager.getConfluenceHome(), "shortcut-map.properties");
        if (shortcutPropFile.exists()) {
            Properties properties = GeneralUtil.getPropertiesFromFile(shortcutPropFile);
            for (Map.Entry entry : properties.entrySet()) {
                ShortcutLinkConfig config = new ShortcutLinkConfig();
                config.setExpandedValue((String)entry.getValue());
                shortcutLinksManager.addShortcutLink((String)entry.getKey(), config);
            }
            shortcutPropFile.delete();
        }
    }

    public Collection getErrors() {
        return null;
    }
}

