/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.util.SQLUtils;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.DatabaseUpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class SpaceGroupUpgradeTask
implements DatabaseUpgradeTask {
    public String getBuildNumber() {
        return "643";
    }

    public String getShortDescription() {
        return "Adds a space group column to the space table";
    }

    public void doUpgrade() throws Exception {
        SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
        Session session = null;
        session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
        if (((String)BootstrapUtils.getBootstrapManager().getProperty("hibernate.dialect")).endsWith("PostgreSQLDialect")) {
            log.info((Object)"Starting SpaceGroup upgrade task for Postgres");
            this.updateSchema(session);
            log.info((Object)"SpaceGroup upgrade task for Postgres complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSchema(Session session) throws HibernateException, SQLException {
        Statement statement;
        block4: {
            statement = null;
            try {
                Connection connection = session.connection();
                statement = connection.createStatement();
                statement.execute("alter table SPACES add column SPACEGROUPID BIGINT");
                if (connection.getAutoCommit()) break block4;
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    log.error((Object)("Unable to add SPACEGROUPID column to SPACES table: " + e.getMessage()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.closeStatementQuietly(statement);
                    throw throwable;
                }
                SQLUtils.closeStatementQuietly(statement);
            }
        }
        SQLUtils.closeStatementQuietly(statement);
    }

    public Collection getErrors() {
        return null;
    }

    public void doNonDatabaseUpgrade() {
    }
}

