/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.core.db.JDBCUtils;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class SpaceRelationUpgradeTask
implements UpgradeTask {
    private static Category log = Category.getInstance(SpaceRelationUpgradeTask.class);
    private String blogSpaceIdQuery;
    private String mailSpaceIdQuery;

    public String getBuildNumber() {
        return "301";
    }

    public String getShortDescription() {
        return "Updates the database to remove some foreign key relationship between spaces and content";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpgrade() throws Exception {
        log.info((Object)"Beginning database update: space relationship");
        SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory");
        Session session = null;
        try {
            String dialect = (String)BootstrapUtils.getBootstrapManager().getProperty("hibernate.dialect");
            this.blogSpaceIdQuery = "alter table CONTENT drop constraint FK6382C0592C31BE9F";
            this.mailSpaceIdQuery = "alter table CONTENT drop constraint FK6382C059A0A8D6EA";
            if (dialect.endsWith("MySQLDialect")) {
                this.blogSpaceIdQuery = "alter table CONTENT drop foreign key FK6382C0592C31BE9F";
                this.mailSpaceIdQuery = "alter table CONTENT drop foreign key FK6382C059A0A8D6EA";
            }
            session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
            session.flush();
            session.clear();
            log.info((Object)" - dropping constraints:");
            this.updateSchema(session);
            log.info((Object)" - moving content:");
            this.moveContent(session);
        }
        catch (Throwable t) {
            log.error((Object)"Error removing foreign key constraints. If the problem is that they don't exist, then this error is harmless.", t);
        }
        finally {
            log.info((Object)"Completed database update: space relationship");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSchema(Session session) throws HibernateException, SQLException {
        Statement statement = null;
        try {
            Connection connection = session.connection();
            statement = connection.createStatement();
            statement.execute(this.blogSpaceIdQuery);
            statement.execute(this.mailSpaceIdQuery);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(statement);
            throw throwable;
        }
        JDBCUtils.close((Statement)statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveContent(Session session) throws HibernateException, SQLException {
        Statement statement = null;
        try {
            Connection connection = session.connection();
            statement = connection.createStatement();
            statement.execute("update CONTENT set SPACEID = BLOGSPACEID where BLOGSPACEID is not null");
            statement.execute("update CONTENT set SPACEID = MAILSPACEID where MAILSPACEID is not null");
            statement.executeUpdate("update CONTENT set SPACEID = DESCSPACEID where DESCSPACEID is not null");
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(statement);
            throw throwable;
        }
        JDBCUtils.close((Statement)statement);
    }

    public Collection getErrors() {
        return null;
    }
}

