/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.upgrade.UpgradeException;
import com.atlassian.upgrade.UpgradeTask;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VersionedAttachmentsUpgradeTask
implements UpgradeTask {
    private List errors = new ArrayList();

    public String getBuildNumber() {
        return "51";
    }

    public String getShortDescription() {
        return "Upgrade attatchments to support new directory structure";
    }

    public void doUpgrade() throws Exception {
        File attachmentRoot = new File(BootstrapUtils.getBootstrapManager().getConfluenceHome() + "/attachments");
        if (!this.isAccessibleDirectory(attachmentRoot)) {
            this.errors.add("Attachments root directory " + attachmentRoot.getAbsolutePath() + " is not accessible. Aborting upgrade");
            throw new UpgradeException("Attachments root directory is not accessible");
        }
        File[] attachmentDirs = attachmentRoot.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        this.fixAttachmentDirectories(attachmentDirs);
    }

    public Collection getErrors() {
        return this.errors;
    }

    private void fixAttachmentDirectories(File[] attachmentDirs) {
        for (int i = 0; i < attachmentDirs.length; ++i) {
            File attachmentDir = attachmentDirs[i];
            if (!this.isAccessibleDirectory(attachmentDir)) {
                this.errors.add("Attachments directory is not accessible " + attachmentDir.getAbsolutePath());
                continue;
            }
            this.fixAttachments(attachmentDir);
        }
    }

    private void fixAttachments(File attachmentDir) {
        File[] attachments = attachmentDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        });
        for (int i = 0; i < attachments.length; ++i) {
            File attachment = attachments[i];
            if (!this.isAccessible(attachment)) {
                this.errors.add("Attachment was not accessible: " + attachment.getAbsolutePath());
                continue;
            }
            this.fixAttachment(attachment);
        }
    }

    private void fixAttachment(File attachment) {
        File tempAttachment = new File(attachment.getAbsolutePath() + ".conftemp");
        if (!attachment.renameTo(tempAttachment)) {
            this.errors.add("Could not create tempfile: " + attachment.getAbsolutePath() + ".conftemp");
            return;
        }
        if (!attachment.mkdir()) {
            this.errors.add("Could not create directory " + attachment);
            tempAttachment.renameTo(attachment);
            return;
        }
        File newAttachment = new File(attachment, "1");
        if (!tempAttachment.renameTo(newAttachment)) {
            this.errors.add("Could not create attachment file " + newAttachment);
        }
    }

    private boolean isAccessibleDirectory(File file) {
        return file.isDirectory() && this.isAccessible(file);
    }

    private boolean isAccessible(File file) {
        return file.canWrite() && file.canRead();
    }
}

