/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade.security;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;

public class LegacyContentPermission
extends ConfluenceEntityObject {
    private static final Category log = Category.getInstance(LegacyContentPermission.class);
    public static final String VIEW_PERMISSION = "View";
    public static final String EDIT_PERMISSION = "Edit";
    private String type;
    private String group;
    private Date expiry;
    private ContentEntityObject content;
    private String comment;
    private UserAccessor userAccessor;

    public LegacyContentPermission(LegacyContentPermission cp) {
        this.type = cp.getType();
        this.group = cp.getGroup();
        this.expiry = cp.getExpiry();
        this.content = cp.getContent();
        this.setCreatorName(cp.getCreatorName());
    }

    public LegacyContentPermission() {
    }

    public LegacyContentPermission(String type) {
        this(type, null);
    }

    public LegacyContentPermission(String type, String group) {
        this.type = type;
        this.group = group;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Date getExpiry() {
        return this.expiry;
    }

    public void setExpiry(Date expiry) {
        this.expiry = expiry;
    }

    public ContentEntityObject getContent() {
        return this.content;
    }

    public void setContent(ContentEntityObject content) {
        this.content = content;
    }

    public boolean isPermitted(User user) {
        if (user == null) {
            return false;
        }
        if (!this.validatePermissionMembers(user)) {
            return false;
        }
        if (user.getName().equalsIgnoreCase(this.getCreatorName())) {
            return true;
        }
        for (Group userGroup : this.getUserAccessor().getGroups(user)) {
            if (!userGroup.getName().equals(this.group)) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        if (StringUtils.isEmpty((String)this.type)) {
            return false;
        }
        if (!this.type.equals(VIEW_PERMISSION) && !this.type.equals(EDIT_PERMISSION)) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.getCreatorName()) && StringUtils.isEmpty((String)this.group)) {
            return false;
        }
        return this.content != null;
    }

    private boolean validatePermissionMembers(User user) {
        if (this.type == null) {
            log.error((Object)"Somebody saved a lock with a null type!");
            return false;
        }
        if (this.group == null && !TextUtils.stringSet((String)this.getCreatorName())) {
            log.error((Object)"A permission was saved without a group and a creator!");
            return false;
        }
        if (user == null) {
            return false;
        }
        if (!TextUtils.stringSet((String)this.getCreatorName())) {
            log.error((Object)("Somebody saved a creator-level lock with no creator username against content: " + this.getContent()));
            return false;
        }
        return true;
    }

    public boolean isGroupPermission() {
        return this.getGroup() != null;
    }

    public boolean isUserPermission() {
        return !this.isGroupPermission();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LegacyContentPermission)) {
            return false;
        }
        LegacyContentPermission legacyContentPermission = (LegacyContentPermission)o;
        if (this.group != null ? !this.group.equals(legacyContentPermission.group) : legacyContentPermission.group != null) {
            return false;
        }
        if (!this.type.equals(legacyContentPermission.type)) {
            return false;
        }
        return !(this.getCreatorName() != null ? !this.getCreatorName().equals(legacyContentPermission.getCreatorName()) : legacyContentPermission.getCreatorName() != null);
    }

    public int hashCode() {
        int result = 37;
        result = 29 * result + this.type.hashCode();
        result = 29 * result + (this.group != null ? this.group.hashCode() : 0);
        result = 29 * result + (this.getCreatorName() != null ? this.getCreatorName().hashCode() : 0);
        return result;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public UserAccessor getUserAccessor() {
        if (this.userAccessor == null) {
            this.userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        }
        return this.userAccessor;
    }

    public ContentPermission toContentPermission() {
        ContentPermission permission = this.isGroupPermission() ? ContentPermission.createGroupPermission(this.type, this.group) : ContentPermission.createUserPermission(this.type, this.getCreatorName());
        permission.setCreatorName(this.getCreatorName());
        permission.setCreationDate(this.getCreationDate());
        permission.setLastModificationDate(this.getLastModificationDate());
        permission.setLastModifierName(this.getLastModifierName());
        return permission;
    }

    public String toString() {
        return "type=" + this.type + ", creatorName=" + this.getCreatorName() + ", group=" + this.group + ", content=" + this.content;
    }
}

