/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user;

import com.atlassian.confluence.event.events.security.LoginEvent;
import com.atlassian.confluence.event.events.security.LoginFailedEvent;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConfluenceAuthenticator
extends DefaultAuthenticator {
    private EventManager eventManager;
    private UserAccessor userAccessor;

    public boolean logout(HttpServletRequest request, HttpServletResponse response) throws AuthenticatorException {
        AuthenticatedUserThreadLocal.setUser(null);
        return super.logout(request, response);
    }

    public boolean login(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String username, String password, boolean b) throws AuthenticatorException {
        if (username == null || !ContainerManager.isContainerSetup()) {
            return false;
        }
        String usernameLower = username.toLowerCase();
        boolean result = super.login(httpServletRequest, httpServletResponse, usernameLower, password, b);
        String remoteIP = httpServletRequest.getRemoteAddr();
        String remoteHost = httpServletRequest.getRemoteHost();
        if (result) {
            this.getEventManager().publishEvent((Event)new LoginEvent((Object)this, username, httpServletRequest.getSession().getId(), remoteHost, remoteIP));
        } else {
            this.getEventManager().publishEvent((Event)new LoginFailedEvent((Object)this, username, httpServletRequest.getSession().getId(), remoteHost, remoteIP));
        }
        return result;
    }

    protected boolean authenticate(Principal user, String password) {
        User atlUser = this.userAccessor.getUser(user.getName());
        return this.getUserAccessor().authenticate(atlUser.getName(), password);
    }

    protected EventManager getEventManager() {
        if (this.eventManager == null) {
            this.eventManager = (EventManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"eventManager");
        }
        return this.eventManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    protected UserAccessor getUserAccessor() {
        if (this.userAccessor == null) {
            this.userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        }
        return this.userAccessor;
    }

    protected Principal getUser(String uid) {
        return this.getUserAccessor().getUser(uid);
    }

    public Principal getUser(HttpServletRequest request, HttpServletResponse httpServletResponse) {
        return super.getUser(request, httpServletResponse);
    }
}

