/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.interceptor.LoginInterceptor;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;

public class ConfluenceLoginInterceptor
implements LoginInterceptor {
    private Category log = Category.getInstance(this.getClass());
    private UserAccessor userAccessor;

    public void beforeLogin(HttpServletRequest request, HttpServletResponse response, String username, String password, boolean cookieLogin) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLogin(HttpServletRequest request, HttpServletResponse response, String username, String password, boolean cookieLogin, String loginStatus) {
        if ("success".equals(loginStatus)) {
            try {
                User user = this.getUserAccessor().getUser(username);
                PropertySet userPropertySet = this.userAccessor.getPropertySet(user);
                String string = username.intern();
                synchronized (string) {
                    try {
                        Date previousLoginDate = userPropertySet.getDate("confluence.user.last.login.date");
                        if (previousLoginDate == null) {
                            this.createPreviousLoginDate(userPropertySet);
                        }
                        try {
                            userPropertySet.remove("confluence.user.previous.login.date");
                        }
                        catch (PropertyException e) {
                            // empty catch block
                        }
                        this.userAccessor.getPropertySet(user).setDate("confluence.user.previous.login.date", previousLoginDate);
                    }
                    catch (PropertyException e) {
                        this.createPreviousLoginDate(userPropertySet);
                    }
                    userPropertySet.remove("confluence.user.last.login.date");
                    userPropertySet.setDate("confluence.user.last.login.date", new Date());
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Can not retrieve the user ('" + username + "') to set the Last-Login-Date for!"), (Throwable)e);
            }
            catch (Throwable t) {
                this.log.error((Object)("Error while setting the user ('" + username + "') Last-Login-Date!"), t);
            }
        }
    }

    private void createPreviousLoginDate(PropertySet userPropertySet) {
        try {
            userPropertySet.setDate("confluence.user.previous.login.date", new Date());
        }
        catch (PropertyException e1) {
            userPropertySet.remove("confluence.user.previous.login.date");
        }
    }

    private UserAccessor getUserAccessor() {
        if (this.userAccessor == null) {
            this.userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        }
        return this.userAccessor;
    }

    public void destroy() {
    }

    public void init(Map map, SecurityConfig securityConfig) {
    }
}

