/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user;

import com.atlassian.user.GroupManager;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.Configuration;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.DefaultDelegationAccessor;
import com.atlassian.user.configuration.DefaultRepositoryAccessor;
import com.atlassian.user.configuration.DelegationAccessor;
import com.atlassian.user.configuration.RepositoryAccessor;
import com.atlassian.user.properties.PropertySetFactory;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.security.authentication.Authenticator;
import org.apache.log4j.Logger;

public class ConfluenceUserContainerConfiguration
implements Configuration {
    private static final Logger log = Logger.getLogger(ConfluenceUserContainerConfiguration.class);
    private DefaultDelegationAccessor delegationAccessor;
    private UserManager userManager;
    private GroupManager groupManager;
    private PropertySetFactory propertySetFactory;
    private Authenticator authenticator;
    private EntityQueryParser entityQueryParser;
    private RepositoryIdentifier repository;
    public boolean initialized;

    public DelegationAccessor getDelegationAccessor() {
        if (!this.initialized) {
            try {
                this.init();
            }
            catch (ConfigurationException e) {
                log.error((Object)"Unable to initialize UserContainerConfiguration", (Throwable)e);
            }
        }
        return this.delegationAccessor;
    }

    public void init() throws ConfigurationException {
        this.delegationAccessor = new DefaultDelegationAccessor();
        DefaultRepositoryAccessor repositoryAccessor = new DefaultRepositoryAccessor();
        repositoryAccessor.setRepository(this.repository);
        repositoryAccessor.setUserManager(this.userManager);
        repositoryAccessor.setGroupManager(this.groupManager);
        repositoryAccessor.setAuthenticator(this.authenticator);
        repositoryAccessor.setPropertySetFactory(this.propertySetFactory);
        repositoryAccessor.setEntityQueryParser(this.entityQueryParser);
        this.delegationAccessor.addRepositoryAccessor((RepositoryAccessor)repositoryAccessor);
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    public void setPropertySetFactory(PropertySetFactory propertySetFactory) {
        this.propertySetFactory = propertySetFactory;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setEntityQueryParser(EntityQueryParser entityQueryParser) {
        this.entityQueryParser = entityQueryParser;
    }

    public void setRepository(RepositoryIdentifier repository) {
        this.repository = repository;
    }
}

