/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.user.preferences.UserPreferences;
import com.opensymphony.module.propertyset.PropertySet;

public class ConfluenceUserPreferences {
    private UserPreferences prefs = null;

    public ConfluenceUserPreferences() {
    }

    public ConfluenceUserPreferences(PropertySet properties) {
        this.prefs = new UserPreferences(properties);
    }

    public TimeZone getTimeZone() {
        if (this.prefs == null) {
            return TimeZone.getDefault();
        }
        return TimeZone.getInstance(this.prefs.getString("confluence.user.time.zone"));
    }

    public DateFormatter getDateFormatter(FormatSettingsManager formatSettingsManager) {
        return new DateFormatter(this.getTimeZone(), formatSettingsManager);
    }

    public void setTimeZone(String timeZoneID) throws AtlassianCoreException {
        if (this.prefs == null) {
            return;
        }
        this.prefs.setString("confluence.user.time.zone", timeZoneID);
    }
}

