/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user;

import bucket.user.LicensingException;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.InsufficientPrivilegeException;
import com.atlassian.confluence.event.events.group.GroupCreateEvent;
import com.atlassian.confluence.event.events.group.GroupRemoveEvent;
import com.atlassian.confluence.event.events.user.UserCreateEvent;
import com.atlassian.confluence.event.events.user.UserDeactivateEvent;
import com.atlassian.confluence.event.events.user.UserReactivateEvent;
import com.atlassian.confluence.event.events.user.UserRemoveEvent;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.impl.delegation.repository.DelegatingRepository;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerUtils;
import com.atlassian.user.search.query.Query;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class DefaultUserAccessor
extends bucket.user.DefaultUserAccessor
implements UserAccessor {
    private static Logger log = Logger.getLogger(DefaultUserAccessor.class);
    private SpacePermissionManager spacePermissionManager;
    private ContentEntityManager contentEntityManager;
    private NotificationManager notificationManager;
    private PersonalInformationManager personalInformationManager;
    private UserChecker userChecker;
    private AttachmentManager attachmentManager;
    private SettingsManager settingsManager;
    private EventManager eventManager;
    private ContentPermissionManager contentPermissionManager;
    private PermissionManager permissionManager;

    public boolean isLicensedToAddMoreUsers() {
        return this.userChecker.isLicensedToAddMoreUsers();
    }

    public void addMembership(Group group, User user) {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.EDIT, group)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        super.addMembership(group, user);
    }

    public boolean removeMembership(Group group, User user) {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.EDIT, group)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        return super.removeMembership(group, user);
    }

    public User addUser(String username, String password, String email, String fullname, String[] groups) {
        if (!this.isLicensedToAddMoreUsers()) {
            throw new LicensingException("You are not licensed to add any more users to this installation of Confluence. Please contact sales@atlassian.com");
        }
        User user = super.addUser(username, password, email, fullname, groups);
        this.personalInformationManager.createPersonalInformation(user);
        this.userChecker.incrementRegisteredUserCount();
        this.eventManager.publishEvent((Event)new UserCreateEvent(this, user));
        return user;
    }

    public Group addGroup(String groupname) {
        if ("confluence-administrators".equals(groupname) && !this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        Group group = super.addGroup(groupname);
        this.eventManager.publishEvent((Event)new GroupCreateEvent(this, group));
        return group;
    }

    public Group createGroup(String groupname) {
        if ("confluence-administrators".equals(groupname) && !this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        Group group = super.createGroup(groupname);
        this.eventManager.publishEvent((Event)new GroupCreateEvent(this, group));
        return group;
    }

    public void removeGroup(Group group) {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.REMOVE, group)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        this.spacePermissionManager.removeAllPermissionsForGroup(group.getName());
        this.contentPermissionManager.removeAllGroupPermissions(group.getName());
        super.removeGroup(group);
        this.eventManager.publishEvent((Event)new GroupRemoveEvent(this, group));
    }

    public void removeUser(User user) {
        if (user == null) {
            throw new IllegalArgumentException("Do not call removeUser with a null user");
        }
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.REMOVE, user)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        this.spacePermissionManager.removeAllUserPermissions(user.getName());
        this.notificationManager.removeAllNotificationsForUser(user);
        this.personalInformationManager.removePersonalInformation(user.getName());
        try {
            PropertySet propertySet = this.getPropertySetFactory().getPropertySet((Entity)user);
            for (String key : propertySet.getKeys()) {
                propertySet.remove(key);
            }
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.eventManager.publishEvent((Event)new UserRemoveEvent(this, user));
        Pager usersGroup = this.getGroups(user);
        for (Group group : usersGroup) {
            this.removeMembership(group, user);
        }
        this.contentPermissionManager.removeAllUserPermissions(user.getName());
        super.removeUser(user);
    }

    public Pager getUsersWithConfluenceAccess() {
        List usePermissions;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_getUsersWithConfluenceAccessor"));
        }
        if ((usePermissions = this.spacePermissionManager.getGlobalPermissions("USECONFLUENCE")).size() == 0) {
            return PagerUtils.EMPTY_PAGER;
        }
        HashSet<User> usersWithAccess = new HashSet<User>();
        for (SpacePermission perm : usePermissions) {
            if (perm.getUserName() != null) {
                User user = this.getUser(perm.getUserName());
                if (user == null || this.isDeactivated(user)) continue;
                usersWithAccess.add(user);
                continue;
            }
            Group group = this.getGroup(perm.getGroup());
            if (group == null) continue;
            for (String username : this.getMemberNames(group)) {
                User user = this.getUser(username);
                if (user != null && !usersWithAccess.contains(user) && username != null && !this.isDeactivated(username)) {
                    usersWithAccess.add(user);
                    continue;
                }
                if (user != null) continue;
                log.info((Object)("Found null when looking for [" + username + "] on permission [" + perm.getType() + "]"));
            }
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_getUsersWithConfluenceAccessor"));
        }
        return new DefaultPager(usersWithAccess);
    }

    public void savePersonalInformation(PersonalInformation newInfo, PersonalInformation oldInfo) {
        if (oldInfo != null && !newInfo.getUsername().equals(oldInfo.getUsername())) {
            throw new IllegalArgumentException("Usernames on update do not match. New: " + newInfo.getUsername() + " Old: " + oldInfo.getUsername());
        }
        this.contentEntityManager.saveContentEntity(newInfo, oldInfo, null);
    }

    public void deactivateUser(User user) {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.SET_PERMISSIONS, user)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        super.deactivateUser(user);
        this.spacePermissionManager.removeAllUserPermissions(user.getName());
        this.eventManager.publishEvent((Event)new UserDeactivateEvent(this, user));
    }

    public void reactivateUser(User user) {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.EDIT, user)) {
            throw new InsufficientPrivilegeException(AuthenticatedUserThreadLocal.getUsername());
        }
        super.reactivateUser(user);
        this.eventManager.publishEvent((Event)new UserReactivateEvent(this, user));
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setPersonalInformationManager(PersonalInformationManager personalInformationManager) {
        this.personalInformationManager = personalInformationManager;
    }

    public boolean isReadOnly(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null.");
        }
        try {
            return this.getUserManager().isReadOnly(user);
        }
        catch (EntityException e) {
            log.error((Object)("Error determining if User [" + user + "] is readonly"), (Throwable)e);
            return false;
        }
    }

    public boolean isReadOnly(Group group) {
        if (group == null) {
            throw new IllegalArgumentException("Group cannot be null.");
        }
        try {
            return this.getGroupManager().isReadOnly(group);
        }
        catch (EntityException e) {
            log.error((Object)("Error determining if Group [ " + group + "] is readonly"), (Throwable)e);
            return false;
        }
    }

    public Pager filterUnaccessibleUsers(Pager userPager, User user) {
        if (GeneralUtil.isSuperUser(user) || !this.settingsManager.getGlobalSettings().isSharedMode()) {
            return userPager;
        }
        List initialResult = PagerUtils.toList((Pager)userPager);
        this.filterUsersFromList(user, initialResult);
        return new DefaultPager((Collection)initialResult);
    }

    private void filterUsersFromList(User user, List initialResult) {
        ArrayList allUserNames = new ArrayList();
        List groups = this.getGroupsAsList(user);
        for (Group group : groups) {
            List memberList = this.getMemberNamesAsList(group);
            allUserNames.addAll(memberList);
        }
        HashSet<User> users = new HashSet<User>();
        for (int i = 0; i < allUserNames.size(); ++i) {
            String username = (String)allUserNames.get(i);
            users.add(this.getUser(username));
        }
        initialResult.retainAll(users);
    }

    public Pager filterUnaccessibleGroups(Pager groupPager, User user) {
        if (GeneralUtil.isSuperUser(user) || !this.settingsManager.getGlobalSettings().isSharedMode()) {
            return groupPager;
        }
        return this.getGroups(user);
    }

    public List getDelegatingRepositories() {
        RepositoryIdentifier repo = this.getUserManager().getIdentifier();
        if (repo instanceof DelegatingRepository) {
            return ((DelegatingRepository)repo).getRepositories();
        }
        return null;
    }

    public void setUserChecker(UserChecker userChecker) {
        this.userChecker = userChecker;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public ProfilePictureInfo getUserProfilePicture(String username) {
        if (username == null) {
            return null;
        }
        User user = this.getUser(username);
        if (user == null) {
            return null;
        }
        PropertySet propertySet = this.getPropertySet(user);
        if (propertySet == null) {
            return null;
        }
        String profilePicture = propertySet.getString("confluence.user.profile.picture");
        if (profilePicture == null) {
            profilePicture = "/images/icons/profilepics/default.gif";
        }
        if (profilePicture.startsWith("/images/icons/profilepics/")) {
            return new ProfilePictureInfo(profilePicture);
        }
        PersonalInformation personalInformation = this.personalInformationManager.getPersonalInformation(user.getName());
        if (personalInformation == null || profilePicture == null) {
            return null;
        }
        Attachment a = this.attachmentManager.getAttachment(personalInformation, profilePicture);
        if (a == null) {
            return new ProfilePictureInfo("/images/icons/profilepics/default.gif");
        }
        return new ProfilePictureInfo(a);
    }

    public boolean isSuperUser(User user) {
        return user != null && this.hasMembership("confluence-administrators", user.getName()) && !this.getPropertySet(user).getBoolean("confluence.user.deactivated");
    }

    public ConfluenceUserPreferences getConfluenceUserPreferences(User user) {
        if (user == null || this.getPropertySet(user) == null) {
            return new ConfluenceUserPreferences();
        }
        return new ConfluenceUserPreferences(this.getPropertySet(user));
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setContentPermissionManager(ContentPermissionManager contentPermissionManager) {
        this.contentPermissionManager = contentPermissionManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public List filterUnaccessibleUsers(List userNameList, User user) {
        if (GeneralUtil.isSuperUser(user) || !this.settingsManager.getGlobalSettings().isSharedMode()) {
            return userNameList;
        }
        this.filterUsersFromList(user, userNameList);
        return userNameList;
    }

    public List filterUnaccessibleGroups(List groupList, User user) {
        if (GeneralUtil.isSuperUser(user) || !this.settingsManager.getGlobalSettings().isSharedMode()) {
            return groupList;
        }
        return this.getGroupsAsList(user);
    }

    public List getGroupsAsList() {
        return PagerUtils.toList((Pager)this.getGroups());
    }

    public List getMemberNamesAsList(Group group) {
        return PagerUtils.toList((Pager)this.getMemberNames(group));
    }

    public List getWriteableGroups() {
        return this.getGroupManager().getWritableGroups();
    }

    public List getUsersWithConfluenceAccessAsList() {
        return PagerUtils.toList((Pager)this.getUsersWithConfluenceAccess());
    }

    public List getGroupsAsList(User user) {
        return PagerUtils.toList((Pager)this.getGroups(user));
    }

    public List findUsersAsList(Query search) throws EntityException {
        return PagerUtils.toList((Pager)this.findUsers(search).pager());
    }
}

