/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user;

import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserContentManager;
import com.atlassian.user.User;
import java.util.List;

public class DefaultUserContentManager
implements UserContentManager {
    private SpaceManager spaceManager;

    public boolean hasAuthoredContent(User user) {
        if (user == null) {
            return false;
        }
        return !this.getUserEditedSpaces(user).isEmpty() || !this.getUserOwnedSpaces(user).isEmpty() || !this.getUserCommentedSpaces(user).isEmpty();
    }

    private List getUserOwnedSpaces(User user) {
        List userOwnedSpaces = this.spaceManager.getAuthoredSpacesByUser(user.getName());
        userOwnedSpaces.remove(this.spaceManager.getPersonalSpace(user));
        return userOwnedSpaces;
    }

    private List getUserEditedSpaces(User user) {
        List userEditedSpaces = this.spaceManager.getSpacesContainingPagesEditedBy(user.getName());
        userEditedSpaces.remove(this.spaceManager.getPersonalSpace(user));
        return userEditedSpaces;
    }

    private List getUserCommentedSpaces(User user) {
        List userCommentedSpaces = this.spaceManager.getSpacesContainingCommentsBy(user.getName());
        userCommentedSpaces.remove(this.spaceManager.getPersonalSpace(user));
        return userCommentedSpaces;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }
}

