/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.util.List;

public class PersonalInformation
extends ContentEntityObject {
    public static final String CONTENT_TYPE = "userinfo";
    private String username;
    private String hasPersonalSpace;
    private String fullName;
    private String email;

    public PersonalInformation() {
    }

    public PersonalInformation(User user, UserAccessor userAccessor) {
        this.setUsername(user.getName());
        this.setContent(userAccessor.getPropertySet(user).getString("confluence.user.personal.info"));
        this.fullName = user.getFullName();
    }

    public String toString() {
        return this.getType() + ": " + this.getUsername() + " v." + this.getVersion() + " (" + this.getId() + ")";
    }

    public String getDisplayTitle() {
        return this.getFullName();
    }

    public String getUrlPath() {
        return "/display/~" + GeneralUtil.urlEncode(this.username);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public List getBodyContents() {
        return super.getBodyContents();
    }

    public boolean belongsTo(User user) {
        return user != null && this.username.equals(user.getName());
    }

    public String getFullName() {
        UserAccessor ua;
        User user;
        if (this.fullName == null && (user = (ua = (UserAccessor)ContainerManager.getInstance().getContainerContext().getComponent((Object)"userAccessor")).getUser(this.username)) != null) {
            this.fullName = user.getFullName();
        }
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getEmail() {
        UserAccessor ua;
        User user;
        if (this.email == null && (user = (ua = (UserAccessor)ContainerManager.getInstance().getContainerContext().getComponent((Object)"userAccessor")).getUser(this.username)) != null) {
            this.email = user.getEmail();
        }
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getType() {
        return CONTENT_TYPE;
    }

    public int hashCode() {
        return super.hashCode() * 29 + (this.username == null ? 0 : this.username.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PersonalInformation that = (PersonalInformation)o;
        return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
    }

    public String getNameForComparison() {
        return this.getUsername();
    }

    public boolean isIndexable() {
        if (!super.isIndexable()) {
            return false;
        }
        SettingsManager sm = (SettingsManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"settingsManager");
        return !sm.getGlobalSettings().isSharedMode();
    }

    public String getHasPersonalSpace() {
        if (this.hasPersonalSpace == null) {
            SpaceManager spaceManager = (SpaceManager)ContainerManager.getComponent((String)"spaceManager");
            this.hasPersonalSpace = String.valueOf(spaceManager.getPersonalSpace(this.username) != null);
        }
        return this.hasPersonalSpace;
    }
}

