/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user;

import bucket.user.BucketHibernateConfigProvider;
import bucket.user.providers.CachingAccessProvider;
import bucket.user.providers.CachingCredentialsProvider;
import bucket.user.providers.CachingProfileProvider;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.DelegationAccessor;
import com.opensymphony.user.provider.hibernate.HibernateAccessProvider;
import com.opensymphony.user.provider.hibernate.HibernateCredentialsProvider;
import com.opensymphony.user.provider.hibernate.HibernateProfileProvider;
import java.io.InputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import uk.ltd.getahead.dwr.util.Logger;

public class UserConfigurationChecker {
    private static Logger log = Logger.getLogger(UserConfigurationChecker.class);

    public static boolean isStandardOsUser() throws DocumentException {
        SAXReader reader = new SAXReader();
        InputStream xmlStream = ClassLoaderUtils.getResourceAsStream((String)"osuser.xml", UserConfigurationChecker.class);
        if (xmlStream == null) {
            log.error("Could not find osuser.xml file.");
            return false;
        }
        Document doc = reader.read(xmlStream);
        if (doc.selectSingleNode("//authenticator[@class='com.opensymphony.user.authenticator.SmartAuthenticator']") == null) {
            return false;
        }
        if (doc.selectNodes("//provider").size() != 3) {
            return false;
        }
        return UserConfigurationChecker.providerExists(doc, CachingCredentialsProvider.class.getName(), HibernateCredentialsProvider.class.getName(), BucketHibernateConfigProvider.class.getName()) && UserConfigurationChecker.providerExists(doc, CachingAccessProvider.class.getName(), HibernateAccessProvider.class.getName(), BucketHibernateConfigProvider.class.getName()) && UserConfigurationChecker.providerExists(doc, CachingProfileProvider.class.getName(), HibernateProfileProvider.class.getName(), BucketHibernateConfigProvider.class.getName());
    }

    private static boolean providerExists(Document doc, String providerClassName, String chainClassname, String chainConfigProviderClass) {
        List credentialsProviderNodes = doc.selectNodes("//provider[@class='" + providerClassName + "']");
        if (credentialsProviderNodes.size() != 1) {
            return false;
        }
        Node credentialsProvider = (Node)credentialsProviderNodes.get(0);
        if (credentialsProvider.selectNodes("*").size() != 2) {
            return false;
        }
        if (credentialsProvider.selectNodes("property[@name='chain.classname' and text()='" + chainClassname + "']").size() != 1) {
            return false;
        }
        return credentialsProvider.selectNodes("property[@name='chain.configuration.provider.class' and text()='" + chainConfigProviderClass + "']").size() == 1;
    }

    public static boolean isStandardAtlassianUser(DelegationAccessor delegationAccessor) throws ConfigurationException {
        if (delegationAccessor != null && delegationAccessor.getRepositoryAccessors().size() != 1) {
            return false;
        }
        return delegationAccessor.getRepositoryAccessor("hibernateRepository") != null;
    }
}

