/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.languages.Language;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.actions.Spaced;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.core.util.PairType;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractUserProfileAction
extends ConfluenceActionSupport
implements Spaced {
    private static final Logger log = Logger.getLogger(AbstractUserProfileAction.class);
    private static final String HTML_FRIENDLY_NAME = "HTML";
    private static final String TEXT_FRIENDLY_NAME = "Text";
    private static final String HTML_MIME_TYPE = "text/html";
    private static final String TEXT_MIME_TYPE = "text/plain";
    public static final String HOMEPAGE_DASHBOARD = "dashboard";
    public static final String HOMEPAGE_SITEHOME = "siteHomepage";
    public static final String HOMEPAGE_PROFILE = "profile";
    protected NotificationManager notificationManager;
    protected String fullName;
    protected String email;
    protected boolean notifyByEmail = false;
    protected boolean notifyForMyOwnActions = false;
    protected PersonalInformationManager personalInformationManager;
    protected SpaceManager spaceManager;
    protected boolean useWysiwygEditor = false;
    protected String mimeType;
    protected PersonalInformation personalInformationEntity;
    protected String personalInformation;
    protected String siteHomePage;
    protected String dashboardLabels;
    private User user;
    private UserPreferences userPreferences;
    protected AttachmentManager attachmentManager;
    private List attachments;
    protected String preferredUserLocale;
    private TimeZone userTimeZone;
    protected List installedLocalePairs;

    public User getUser() {
        if (this.user == null && StringUtils.isNotEmpty((String)this.getUsername())) {
            this.user = this.userAccessor.getUser(this.getUsername());
        }
        return this.user;
    }

    public String getFullName() {
        if (this.fullName == null && this.getUser() != null) {
            this.fullName = this.getUser().getFullName();
        }
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public boolean isNotifyForMyOwnActions() {
        if (this.getUserPreferences() != null) {
            this.notifyForMyOwnActions = this.getUserPreferences().getBoolean("confluence.prefs.notify.for.my.own.actions");
        }
        return this.notifyForMyOwnActions;
    }

    public void setNotifyForMyOwnActions(boolean notifyForMyOwnActions) {
        this.notifyForMyOwnActions = notifyForMyOwnActions;
    }

    public void setNotifyByEmail(boolean notifyByEmail) {
        this.notifyByEmail = notifyByEmail;
    }

    public boolean isNotifyByEmail() {
        this.notifyByEmail = this.notificationManager.getDailyReportNotificationForUser(this.getRemoteUser()) != null;
        return this.notifyByEmail;
    }

    protected UserPreferences getUserPreferences() {
        if (this.userPreferences == null) {
            this.userPreferences = new UserPreferences(this.userAccessor.getPropertySet(this.getUser()));
        }
        return this.userPreferences;
    }

    public String getMimeType() {
        if (this.mimeType == null) {
            if (this.getUserPreferences() != null) {
                this.mimeType = this.getUserPreferences().getString("confluence.prefs.email.mimetype");
            }
            if (this.mimeType == null || this.mimeType.equals("html")) {
                this.mimeType = HTML_MIME_TYPE;
            }
        }
        return this.mimeType;
    }

    public String getMimeTypeUserFriendly() {
        try {
            if (this.getMimeType() == null || this.getMimeType().equals(HTML_MIME_TYPE)) {
                return this.getText("mimetypes.HTML");
            }
            return this.getText("mimetypes.Text");
        }
        catch (RuntimeException e) {
            log.error((Object)("Unable to look up user's preferred mime type. User = " + this.getUser() + ", " + e.toString()), (Throwable)e);
            throw e;
        }
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public List getMimeTypes() {
        ArrayList<PairType> mimeTypes = new ArrayList<PairType>();
        mimeTypes.add(new PairType((Serializable)((Object)this.getText("mimetypes.HTML")), (Serializable)((Object)HTML_MIME_TYPE)));
        mimeTypes.add(new PairType((Serializable)((Object)this.getText("mimetypes.Text")), (Serializable)((Object)TEXT_MIME_TYPE)));
        return mimeTypes;
    }

    public String getEmail() {
        if (this.email == null && this.getUser() != null) {
            this.email = this.getUser().getEmail();
        }
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public PersonalInformation getPersonalInformationEntity() {
        User user = this.getUser();
        if (this.personalInformationEntity == null && user != null) {
            this.personalInformationEntity = this.personalInformationManager.getPersonalInformation(user);
        }
        return this.personalInformationEntity;
    }

    public String getPersonalInformation() {
        PersonalInformation pi;
        if (this.personalInformation == null && (pi = this.getPersonalInformationEntity()) != null) {
            this.personalInformation = pi.getContent();
        }
        return this.personalInformation;
    }

    public void setPersonalInformation(String personalInformation) {
        this.personalInformation = personalInformation;
    }

    public String getSiteHomePageName() {
        String siteHomePage = this.getSiteHomePage();
        if (!TextUtils.stringSet((String)siteHomePage) || HOMEPAGE_SITEHOME.equals(siteHomePage)) {
            return this.getText("homepage.default", new String[]{this.getGlobalHomepageSetting()});
        }
        if (HOMEPAGE_DASHBOARD.equals(siteHomePage)) {
            return this.getText("dashboard.name");
        }
        if (HOMEPAGE_PROFILE.equals(siteHomePage)) {
            return this.getText("selection.your.profile");
        }
        return this.getFriendlySpaceName(siteHomePage);
    }

    public String getSiteHomePage() {
        if (this.siteHomePage == null) {
            this.siteHomePage = this.userAccessor.getPropertySet(this.getRemoteUser()).getString("confluence.user.site.homepage");
        }
        if (this.siteHomePage == null) {
            this.siteHomePage = "";
        }
        return this.siteHomePage;
    }

    public void setSiteHomePage(String siteHomePage) {
        this.siteHomePage = siteHomePage;
    }

    public String getUsername() {
        if (this.getRemoteUser() != null) {
            return this.getRemoteUser().getName();
        }
        return null;
    }

    public boolean isViewingMyProfile() {
        return this.isMyProfile();
    }

    protected boolean isMyProfile() {
        return this.getPersonalInformationEntity().belongsTo(this.getRemoteUser());
    }

    public ProfilePictureInfo getUserProfilePicture() {
        return this.userAccessor.getUserProfilePicture(this.getRemoteUser().getName());
    }

    public List getAttachments() {
        if (this.attachments == null) {
            if (this.getPersonalInformationEntity() == null) {
                return null;
            }
            this.attachments = this.attachmentManager.getLatestVersionsOfAttachments(this.getPersonalInformationEntity());
        }
        return this.attachments;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public boolean isShowingAttachments() {
        return false;
    }

    public String doDefault() throws Exception {
        if (this.getRemoteUser() != null) {
            this.notifyByEmail = this.notificationManager.getDailyReportNotificationForUser(this.getRemoteUser()) != null;
        }
        return super.doDefault();
    }

    public boolean isUseWysiwygEditor() {
        if (this.getUserPreferences() != null) {
            this.useWysiwygEditor = this.getUserPreferences().getBoolean("confluence.user.runtime.edit-wysiwyg");
        }
        return this.useWysiwygEditor;
    }

    public void setUseWysiwygEditor(boolean useWysiwygEditor) {
        this.useWysiwygEditor = useWysiwygEditor;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setPersonalInformationManager(PersonalInformationManager personalInformationManager) {
        this.personalInformationManager = personalInformationManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setDashboardLabels(String labels) {
        this.dashboardLabels = labels;
    }

    public String getDashboardLabels() {
        if (this.getUserPreferences() != null && this.dashboardLabels == null) {
            this.dashboardLabels = this.getUserPreferences().getString("confluence.user.dashboard.labels");
        }
        return this.dashboardLabels;
    }

    public String getUserLocaleName() {
        if ("none".equals(this.getLocaleString())) {
            return this.getText("language.default", new String[]{this.getGlobalDefaultLanguage().getDisplayLanguage()});
        }
        for (PairType pairType : this.getInstalledLocalePairs()) {
            if (!pairType.getKey().equals(this.getLocaleString())) continue;
            return (String)((Object)pairType.getValue());
        }
        return null;
    }

    public List getInstalledLocalePairs() {
        if (this.installedLocalePairs == null) {
            List installedLanguages = this.languageManager.getLanguages();
            ArrayList<PairType> localePairs = new ArrayList<PairType>();
            localePairs.add(0, new PairType((Serializable)((Object)"None"), (Serializable)((Object)this.getText("language.default", new String[]{this.getGlobalDefaultLanguage().getDisplayLanguage()}))));
            for (int i = 0; i < installedLanguages.size(); ++i) {
                Language language = (Language)installedLanguages.get(i);
                if (!language.isLicensed()) continue;
                PairType pair = new PairType((Serializable)((Object)language.getName()), (Serializable)((Object)language.getDisplayLanguage()));
                localePairs.add(pair);
            }
            this.installedLocalePairs = localePairs;
        }
        return this.installedLocalePairs;
    }

    private Language getGlobalDefaultLanguage() {
        String defaultLocale = this.getGlobalSettings().getGlobalDefaultLocale();
        if (!TextUtils.stringSet((String)defaultLocale) || this.languageManager.getLanguage(defaultLocale) == null) {
            return this.languageManager.getLanguage("en_GB");
        }
        return this.languageManager.getLanguage(defaultLocale);
    }

    public Space getSpace() {
        if (this.getUser() != null) {
            return this.spaceManager.getSpace(this.getPersonalSpaceKey(this.getUser()));
        }
        if (this.getRemoteUser() != null) {
            return this.spaceManager.getSpace(this.getPersonalSpaceKey(this.getRemoteUser()));
        }
        return null;
    }

    protected String getPersonalSpaceKey(User user) {
        return "~" + user.getName();
    }

    public void setPreferredUserLocale(String locale) {
        this.preferredUserLocale = locale;
    }

    public String getPreferredUserLocale() {
        if (this.preferredUserLocale == null) {
            this.preferredUserLocale = this.getUserPreferences().getString("confluence.user.locale");
        }
        return this.preferredUserLocale;
    }

    protected String getGlobalHomepageSetting() {
        String siteHomePage = this.getGlobalSettings().getSiteHomePage();
        siteHomePage = HOMEPAGE_DASHBOARD.equals(siteHomePage) || siteHomePage == null ? this.getText("dashboard.name") : this.getFriendlySpaceName(siteHomePage);
        return siteHomePage;
    }

    private String getFriendlySpaceName(String siteHomePage) {
        Space homePageSpace = this.spaceManager.getSpace(siteHomePage);
        if (homePageSpace != null) {
            siteHomePage = homePageSpace.getName() + " (" + homePageSpace.getKey() + ")";
        }
        return siteHomePage;
    }

    public boolean isPermitted() {
        return this.getUsername() != null && super.isPermitted();
    }

    public String getUserTimeZone() {
        if (this.userTimeZone == null) {
            this.userTimeZone = this.userAccessor.getConfluenceUserPreferences(this.getUser()).getTimeZone();
        }
        return this.userTimeZone.getID();
    }

    public void setUserTimeZone(String timeZoneID) {
        this.userTimeZone = TimeZone.getInstance(timeZoneID);
    }

    public WebInterfaceContext getWebInterfaceContext() {
        DefaultWebInterfaceContext result = new DefaultWebInterfaceContext(super.getWebInterfaceContext());
        result.setPersonalInformation(this.getPersonalInformationEntity());
        return result;
    }
}

