/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.user.EntityException;
import com.atlassian.user.security.authentication.InvalidPasswordException;

public class ChangeMyPasswordAction
extends AbstractUserProfileAction {
    private String currentPassword;
    private String newPassword;
    private String newPasswordConfirmation;

    public String getCurrentPassword() {
        return this.currentPassword;
    }

    public void setCurrentPassword(String currentPassword) {
        this.currentPassword = currentPassword;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getNewPasswordConfirmation() {
        return this.newPasswordConfirmation;
    }

    public void setNewPasswordConfirmation(String newPasswordConfirmation) {
        this.newPasswordConfirmation = newPasswordConfirmation;
    }

    public void validate() {
        if (!this.userAccessor.authenticate(this.getUser().getName(), this.currentPassword)) {
            this.addActionError(this.getText("cur.pass.not.correct"));
        }
    }

    public String execute() throws Exception {
        try {
            this.userAccessor.alterPassword(this.getUser(), this.newPassword);
        }
        catch (InvalidPasswordException e) {
            this.addFieldError("newPassword", this.getText("new.pass.invalid"));
            return "error";
        }
        catch (EntityException e) {
            LOG.error((Object)"error setting password", (Throwable)e);
            this.addFieldError("newPassword", this.getText("new.pass.error"));
            return "error";
        }
        return "success";
    }

    public boolean isPermitted() {
        return this.getUsername() != null && super.isPermitted();
    }
}

