/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import bucket.user.LicensingException;
import com.atlassian.confluence.user.actions.AbstractUsersAction;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import com.atlassian.license.applications.confluence.ConfluenceLicenseTypeStore;
import java.util.Arrays;

public class CreateUserAction
extends AbstractUsersAction {
    protected String password;
    protected String confirm;
    protected String email;
    protected String fullname;

    public String doDefault() throws Exception {
        if (!this.getUserAccessor().isLicensedToAddMoreUsers()) {
            this.addLicensingError();
        }
        return super.doDefault();
    }

    public String execute() throws Exception {
        if (!this.password.equals(this.confirm)) {
            this.addFieldError("confirm", this.getText("passwords.dontmatch"));
            return "input";
        }
        try {
            this.userAccessor.addUser(this.username, this.password, this.email, this.fullname, new String[]{"confluence-users"});
        }
        catch (LicensingException e) {
            this.addLicensingError();
            return "error";
        }
        return "success";
    }

    protected void addLicensingError() {
        License license = LicenseManager.getInstance().getLicense("CONF");
        int currentUsers = 0;
        currentUsers = this.userAccessor.getUsersWithConfluenceAccessAsList().size();
        if (license == null) {
            this.addActionError(this.getText("no.license", new String[]{this.getText("mailto.confluence.support")}));
        } else if (license.getUsers() <= currentUsers) {
            String msgKey = "too.many.users";
            if (license.getLicenseType().equals(ConfluenceLicenseTypeStore.PERSONAL)) {
                msgKey = msgKey + ".personal";
            }
            this.addActionError(this.getText(msgKey, Arrays.asList(license.getUsers(), currentUsers)) + "<p>" + this.getText("buy.upgrade", new String[]{this.getText("hitcounter.buy.upgrade")}) + " " + this.getText("license.upgrades", new String[]{this.getText("hitcounter.license.upgrades")}) + "</p>" + this.getText("contact.us", new String[]{this.getText("mailto.sales")}));
        } else {
            this.addActionError(this.getText("no.license", new String[]{this.getText("mailto.confluence.support")}));
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }
}

