/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class EditNotificationsAction
extends AbstractUserProfileAction {
    private long pageId;
    private String spaceKey;
    private PageManager pageManager;
    private boolean changesSaved = false;

    public String doRemoveSpaceNotification() throws Exception {
        if (this.spaceKey != null) {
            Space space = this.spaceManager.getSpace(this.spaceKey);
            if (space != null) {
                Notification notification = this.notificationManager.getNotificationByUserAndSpace(this.getUser(), this.spaceKey);
                if (notification != null) {
                    this.notificationManager.removeNotification(notification);
                }
            } else {
                this.addActionError(this.getText("could.not.find.space.matching.key", new Object[]{this.spaceKey}));
            }
        }
        return "success";
    }

    public String doRemovePageNotification() throws Exception {
        Notification notification;
        if (this.getPage() != null && (notification = this.notificationManager.getNotificationByUserAndPage(this.getUser(), this.getPage())) != null) {
            this.notificationManager.removeNotification(notification);
        }
        return "success";
    }

    public List getPageNotificationsForUser() {
        List notificationsForUser = this.notificationManager.getNotificationsByUser(this.getUser());
        ArrayList<Notification> pageNotificationsForUser = new ArrayList<Notification>();
        ListIterator iter = notificationsForUser.listIterator();
        while (iter.hasNext()) {
            Notification notif = (Notification)iter.next();
            if (notif.getPage() == null) continue;
            pageNotificationsForUser.add(notif);
        }
        return pageNotificationsForUser.isEmpty() ? null : pageNotificationsForUser;
    }

    public List getSpaceNotificationsForUser() {
        List notificationsForUser = this.notificationManager.getNotificationsByUser(this.getUser());
        ArrayList<Notification> spaceNotificationsForUser = new ArrayList<Notification>();
        ListIterator iter = notificationsForUser.listIterator();
        while (iter.hasNext()) {
            Notification notif = (Notification)iter.next();
            if (notif.getPage() != null) continue;
            spaceNotificationsForUser.add(notif);
        }
        return spaceNotificationsForUser.isEmpty() ? null : spaceNotificationsForUser;
    }

    public AbstractPage getPage() {
        AbstractPage page = null;
        if (this.pageId > 0L) {
            page = this.pageManager.getAbstractPage(this.pageId);
        }
        return page;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public boolean isPageRequired() {
        return false;
    }

    public boolean isLatestVersionRequired() {
        return false;
    }

    public boolean isPermitted() {
        return this.getUsername() != null && super.isPermitted();
    }

    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public boolean isChangesSaved() {
        return this.changesSaved;
    }

    public void setChangesSaved(boolean changesSaved) {
        this.changesSaved = changesSaved;
    }
}

