/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.mail.template.PreRenderedMailNotificationQueueItem;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.Query;
import com.opensymphony.util.TextUtils;
import java.util.List;
import org.apache.log4j.Logger;

public class ForgotUserNameAction
extends ConfluenceActionSupport {
    private static final Logger log = Logger.getLogger(ForgotUserNameAction.class);
    private String email;
    private List users;

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void validate() {
        super.validate();
        if (!GeneralUtil.isOutgoingMailConfigured()) {
            this.addActionError(this.getText("forgot.username.nomailserver"));
        }
        if (!TextUtils.stringSet((String)this.email)) {
            this.addFieldError("email", this.getText("email.empty"));
        } else if (this.getUsers() == null || this.getUsers().isEmpty()) {
            this.addFieldError("email", this.getText("user.doesnt.exist"));
        }
    }

    private List getUserList(String email) {
        List result = null;
        EmailTermQuery query = new EmailTermQuery(email);
        try {
            result = this.userAccessor.findUsersAsList((Query)query);
        }
        catch (EntityException e) {
            log.error((Object)"Unable to find users", (Throwable)e);
        }
        return result;
    }

    public List getUsers() {
        if (this.users == null) {
            this.users = this.getUserList(this.email);
        }
        return this.users;
    }

    public boolean isPermitted() {
        return true;
    }

    public String execute() throws Exception {
        User user = (User)this.getUsers().get(0);
        PreRenderedMailNotificationQueueItem queueItem = (PreRenderedMailNotificationQueueItem)PreRenderedMailNotificationQueueItem.createFromTemplateFile(user, "forgotusername-notification.vm", this.getText("forgot.username.subject"));
        queueItem.addVelocityContextParam("action", this);
        queueItem.render();
        MultiQueueTaskManager tm = (MultiQueueTaskManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"taskManager");
        tm.addTask("mail", (Task)queueItem);
        return "success";
    }
}

