/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.links.LinkManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.ConfluenceSearchScope;
import com.atlassian.confluence.search.SpacePickerHelper;
import com.atlassian.confluence.search.actions.SearchBean;
import com.atlassian.confluence.search.actions.SearchQueryBean;
import com.atlassian.confluence.search.actions.SearchResultWithExcerpt;
import com.atlassian.confluence.search.scope.SpaceScope;
import com.atlassian.confluence.search.scope.TypeScope;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.actions.ViewUserHistoryAction;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.xwork.ActionContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class PagePickerAction
extends ViewUserHistoryAction {
    private static Logger log = Logger.getLogger(PagePickerAction.class);
    private String formname;
    private String fieldname;
    private String currentspace;
    private String mode;
    private long pageId;
    private int startIndex;
    private List historyPages;
    private List recentlyUpdatedPages;
    private List referringPages;
    private PageManager pageManager;
    private LinkManager linkManager;
    public static final int MAXRESULTS = 10;
    private SearchBean searchBean;
    private SpaceManager spaceManager;
    private SearchQueryBean searchQuery;
    private SpacePickerHelper spacePickerHelper;
    private static final ConfluenceSearchScope TYPE_SCOPE = new TypeScope(EasyList.build((Object)"page", (Object)"blogpost", (Object)"attachment"));

    public List getHistoryPages() {
        if (this.historyPages == null) {
            this.historyPages = new ArrayList();
            for (ContentEntityObject contentEntityObject : this.getHistory()) {
                boolean notUserInfo = !"userinfo".equals(contentEntityObject.getType());
                boolean hasPermission = this.permissionManager.hasPermission(this.getRemoteUser(), Permission.VIEW, contentEntityObject);
                if (!notUserInfo || !hasPermission) continue;
                this.historyPages.add(contentEntityObject);
            }
        }
        return this.historyPages;
    }

    public List getRecentlyUpdatedPages() {
        if (this.recentlyUpdatedPages == null && this.pageManager != null) {
            this.recentlyUpdatedPages = this.getPermittedEntitiesOf(this.pageManager.getRecentlyUpdatedPages(10, null));
        }
        return this.recentlyUpdatedPages;
    }

    public String execute() throws Exception {
        this.spacePickerHelper = new SpacePickerHelper(this.spaceManager, this.labelManager);
        if ("search".equals(this.mode)) {
            this.getSearchResults();
        }
        return super.execute();
    }

    public List getSearchResults() throws IOException {
        if (StringUtils.isNotBlank((String)this.getSearchQuery().getQueryString())) {
            this.getSearchBean().getPaginationSupport().setStartIndex(this.startIndex);
            SearchQueryBean searchQuery = this.getSearchQuery();
            ContainerManager.autowireComponent((Object)searchQuery);
            Query query = searchQuery.buildQuery();
            TYPE_SCOPE.restrictQuery(null, (BooleanQuery)query);
            if (searchQuery.getSpaceKey() != null && !searchQuery.getSpaceKey().equals("")) {
                new SpaceScope(searchQuery.getSpaceKey(), this.labelManager).restrictQuery(null, (BooleanQuery)query);
            }
            this.searchBean.search(query);
            List searchResult = this.searchBean.getPaginationSupport().getPage();
            LinkedList<Object> result = new LinkedList<Object>();
            for (SearchResultWithExcerpt resultWithExcerpt : searchResult) {
                if (resultWithExcerpt == null || resultWithExcerpt.getResultObject() == null) continue;
                result.add(resultWithExcerpt.getResultObject());
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public List getReferringPages() {
        if (this.referringPages == null) {
            this.referringPages = new ArrayList();
            Page pageBeingEdited = this.pageManager.getPage(this.getPageId());
            for (ContentEntityObject contentEntityObject : this.linkManager.getReferringContent(pageBeingEdited)) {
                if (!(contentEntityObject instanceof Page) || !this.permissionManager.hasPermission(this.getRemoteUser(), Permission.VIEW, contentEntityObject)) continue;
                this.referringPages.add(contentEntityObject);
            }
        }
        return this.referringPages;
    }

    public List getAvailableSpaces() {
        return this.spacePickerHelper.getAvailableSpaces(this.getRemoteUser());
    }

    public List getAggregateOptions() {
        return this.spacePickerHelper.getAggregateOptions(this);
    }

    public List getFavouriteSpaces() {
        return this.spacePickerHelper.getFavouriteSpaces(this.getRemoteUser());
    }

    public boolean isNewPage() {
        return this.getPageId() == 0L;
    }

    public SearchQueryBean getSearchQuery() {
        if (this.searchQuery == null) {
            this.searchQuery = (SearchQueryBean)ActionContext.getContext().getSession().get("confluence.search.query.bean");
            if (this.searchQuery == null) {
                this.resetSearchQueryBean();
            }
        }
        return this.searchQuery;
    }

    protected void resetSearchQueryBean() {
        this.searchQuery = new SearchQueryBean();
        ActionContext.getContext().getSession().put("confluence.search.query.bean", this.searchQuery);
    }

    public ContentEntityObject getContentEntityObject() {
        return this.pageManager.getById(this.getPageId());
    }

    public boolean isUpdate() {
        return this.getContentEntityObject() != null;
    }

    public String getFormname() {
        return this.formname;
    }

    public void setFormname(String formname) {
        this.formname = formname;
    }

    public String getFieldname() {
        return this.fieldname;
    }

    public void setFieldname(String fieldname) {
        this.fieldname = fieldname;
    }

    public String getCurrentspace() {
        return this.currentspace;
    }

    public void setCurrentspace(String currentspace) {
        this.currentspace = currentspace;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setSearchBean(SearchBean searchBean) {
        this.searchBean = searchBean;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setLinkManager(LinkManager linkManager) {
        this.linkManager = linkManager;
    }

    public long getPageId() {
        return this.pageId;
    }

    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    public SearchBean getSearchBean() {
        return this.searchBean;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public void setQuery(String query) {
        try {
            this.getSearchQuery().setQueryString(query);
        }
        catch (IOException e) {
            log.error((Object)("Error setting query: " + query), (Throwable)e);
        }
    }

    public String getQuery() {
        return this.getSearchQuery().getQueryString();
    }
}

