/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import bucket.core.actions.PaginationSupport;
import com.atlassian.bonnie.AnyTypeObjectDao;
import com.atlassian.bonnie.Searcher;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.search.actions.SearchBean;
import com.atlassian.confluence.search.actions.SearchQueryBean;
import com.atlassian.confluence.search.actions.SearchResultWithExcerpt;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.ActionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public class PeopleDirectoryAction
extends ConfluenceActionSupport {
    private static final Logger log = Logger.getLogger(PeopleDirectoryAction.class);
    public static final int MAX_PEOPLE_PER_PAGE = 50;
    private SearchQueryBean searchQueryBean;
    private Searcher searcher;
    private SpaceManager spaceManager;
    private SearchBean searchBean;
    private List searchResults = new ArrayList();
    private Set favouritePeople;
    private int startIndex;
    private SettingsManager settingsManager;
    public static final String BROWSE_PEOPLE = "browsepeople";
    private boolean showOnlyPersonal;

    public void validate() {
        if (this.getSearchQueryBean().getQueryString() != null && this.getSearchQueryBean().getQueryString().startsWith("*")) {
            this.addFieldError("searchQueryBean.queryString", this.getText("people.search.error.wildcard"));
        }
    }

    public String execute() throws Exception {
        if (TextUtils.stringSet((String)this.getOldSearchString())) {
            return "oldsearch";
        }
        return BROWSE_PEOPLE;
    }

    private boolean isPeopleDirectoryDisabled() {
        return "true".equals(System.getProperty("confluence.disable.peopledirectory.all")) || "true".equals(System.getProperty("confluence.disable.peopledirectory.anonymous")) && this.getRemoteUser() == null || this.settingsManager.getGlobalSettings().isSharedMode();
    }

    public String getSelectedTab() {
        return (String)ActionContext.getContext().getSession().get("confluence.user.dir.selected.tab");
    }

    public void setSelectedTab(String selectedTab) {
        ActionContext.getContext().getSession().put("confluence.user.dir.selected.tab", selectedTab);
    }

    public String getOldSearchString() {
        return (String)ActionContext.getContext().getSession().get("confluence.user.dir.search.string");
    }

    public String getOldStartIndex() {
        return (String)ActionContext.getContext().getSession().get("confluence.user.dir.start.index");
    }

    public String doSearch() {
        ActionContext.getContext().getSession().put("confluence.user.dir.search.string", this.getSearchQueryBean().getQueryString());
        this.search();
        return "success";
    }

    public String doBrowse() throws Exception {
        if (this.isPeopleDirectoryDisabled()) {
            this.addActionError(this.getText("people.directory.disabled"));
            return "error";
        }
        this.getSearchQueryBean().setQueryString("");
        this.search();
        return "success";
    }

    private void search() {
        SearchQueryBean wiredSearchQueryBean = this.getWiredSearchQueryBean();
        Query query = wiredSearchQueryBean.buildPeopleQuery(this.isShowOnlyPersonal());
        this.searchBean.getPaginationSupport().setStartIndex(this.getStartIndex());
        this.searchBean.search(query, null, new Sort(new SortField("fullNameUntokenized", this.getLocale())));
        for (SearchResultWithExcerpt searchResult : this.searchBean.getPaginationSupport().getPage()) {
            Object resultObject = searchResult.getResultObject();
            PersonalInformation personalInfo = (PersonalInformation)resultObject;
            User user = this.userAccessor.getUser(personalInfo.getUsername());
            if (user == null || this.userAccessor.isDeactivated(user) || !this.spacePermissionManager.hasPermission("USECONFLUENCE", null, user)) continue;
            boolean hasPersonalSpace = this.spaceManager.getPersonalSpace(personalInfo.getUsername()) != null;
            this.searchResults.add(new Person(personalInfo.getUsername(), hasPersonalSpace));
        }
    }

    public SearchQueryBean getSearchQueryBean() {
        if (this.searchQueryBean == null) {
            this.searchQueryBean = new SearchQueryBean();
        }
        return this.searchQueryBean;
    }

    private SearchQueryBean getWiredSearchQueryBean() {
        this.searchQueryBean.setSearcher(this.searcher);
        this.searchQueryBean.setUserAccessor(this.userAccessor);
        this.searchQueryBean.setSpaceManager(this.spaceManager);
        this.searchQueryBean.setLabelManager(this.labelManager);
        this.searchQueryBean.setSettingsManager(this.settingsManager);
        return this.searchQueryBean;
    }

    public Set getFavouritePeople() {
        if (this.favouritePeople == null) {
            this.favouritePeople = new TreeSet();
            if (this.getRemoteUser() != null) {
                List favouritePersonalSpaces = this.getPermittedEntitiesOf(this.labelManager.getFavouriteSpaces(this.getRemoteUser().getName()));
                for (Space space : favouritePersonalSpaces) {
                    if (!space.isPersonal()) continue;
                    this.favouritePeople.add(new Person(space.getCreatorName(), true));
                }
                Label favouriteLabel = this.labelManager.getLabel("my:favourite");
                if (favouriteLabel != null) {
                    List favouriteUserProfiles = this.labelManager.getContent(favouriteLabel);
                    for (Object content : favouriteUserProfiles) {
                        if (!(content instanceof PersonalInformation)) continue;
                        this.favouritePeople.add(new Person(((PersonalInformation)content).getUsername(), false));
                    }
                }
            }
        }
        return this.favouritePeople;
    }

    public List getSearchResults() {
        return this.searchResults;
    }

    public void setSearcher(Searcher searcher) {
        this.searcher = searcher;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setAnyTypeObjectDao(AnyTypeObjectDao anyTypeObjectDao) {
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
        ActionContext.getContext().getSession().put("confluence.user.dir.start.index", Integer.toString(startIndex));
    }

    public boolean shouldShowFavourites() {
        return this.getRemoteUser() != null;
    }

    public boolean shouldShowMailtoLinks() {
        return "email.address.public".equals(this.settingsManager.getGlobalSettings().getEmailAddressVisibility());
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public boolean isShowOnlyPersonal() {
        return this.showOnlyPersonal;
    }

    public void setShowOnlyPersonal(boolean showOnlyPersonal) {
        this.showOnlyPersonal = showOnlyPersonal;
    }

    public void setSearchBean(SearchBean searchBean) {
        this.searchBean = searchBean;
        this.searchBean.setPaginationSupport(new PaginationSupport(50));
    }

    public SearchBean getSearchBean() {
        return this.searchBean;
    }

    public class Person
    implements Comparable {
        private String username;
        private String fullname;
        private User user;
        private String CONTEXT_PATH = ServletActionContext.getRequest().getContextPath();
        private String SPACE_ADD_FAV_URL = this.CONTEXT_PATH + "/addpersonalspacetofavourites.action?nonBlankResult=true&key=";
        private String SPACE_REMOVE_FAV_URL = this.CONTEXT_PATH + "/removepersonalspacefromfavourites.action?nonBlankResult=true&key=";
        private String PROFILE_ADD_FAV_URL = this.CONTEXT_PATH + "/addprofiletofavourites.action?username=";
        private String PROFILE_REMOVE_FAV_URL = this.CONTEXT_PATH + "/removeprofilefromfavourites.action?username=";
        private boolean hasPersonalSpace = true;

        public Person(String username, boolean hasPersonalSpace) {
            this.username = username;
            this.hasPersonalSpace = hasPersonalSpace;
        }

        public String getNameWithTilde() {
            return "~" + this.username;
        }

        public String getEmailUrl() {
            if (this.getUser() == null || !TextUtils.stringSet((String)this.getUser().getEmail())) {
                return "";
            }
            return "mailto:" + this.getUser().getEmail();
        }

        public String getAddFavouriteUrl() {
            if (this.hasPersonalSpace) {
                return this.SPACE_ADD_FAV_URL + this.getNameWithTilde();
            }
            return this.PROFILE_ADD_FAV_URL + this.username;
        }

        public String getRemoveFavouriteUrl() {
            if (this.hasPersonalSpace) {
                return this.SPACE_REMOVE_FAV_URL + this.getNameWithTilde();
            }
            return this.PROFILE_REMOVE_FAV_URL + this.username;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            if (this.hasPersonalSpace != person.hasPersonalSpace) {
                return false;
            }
            return this.username.equals(person.username);
        }

        public String getUsername() {
            return this.username;
        }

        public String getFullname() {
            if (this.fullname == null) {
                this.fullname = this.getUser() != null && this.getUser().getFullName() != null ? this.getUser().getFullName() : "";
            }
            return this.fullname;
        }

        public int hashCode() {
            int result = this.username.hashCode();
            result = this.hasPersonalSpace ? 29 * result : result;
            return result;
        }

        public boolean isHasPersonalSpace() {
            return this.hasPersonalSpace;
        }

        public int compareTo(Object o) {
            if (!(o instanceof Person)) {
                throw new IllegalArgumentException("Object must be of type: " + Person.class);
            }
            return this.getFullname().compareTo(((Person)o).getFullname());
        }

        public boolean isFavourite() {
            return PeopleDirectoryAction.this.getFavouritePeople().contains(this);
        }

        private User getUser() {
            if (this.user == null) {
                try {
                    this.user = PeopleDirectoryAction.this.userAccessor.getUser(this.username);
                }
                catch (Exception e) {
                    log.error((Object)("Unable to retrieve user: " + this.username + ": " + e.getMessage()), (Throwable)e);
                }
            }
            return this.user;
        }
    }
}

