/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.user.actions.AbstractGroupAction;
import com.atlassian.user.Group;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class RemoveGroupAction
extends AbstractGroupAction {
    String confirm;
    private SpaceManager spaceManager;

    public void validate() {
        super.validate();
        if (!TextUtils.stringSet((String)this.name)) {
            this.addActionError(this.getText("name.empty"));
        }
        if (this.userAccessor.getGroup(this.name) == null) {
            this.addActionError(this.getText("group.doesnt.exist"));
        }
    }

    public String doDefault() throws Exception {
        HashSet<String> adminGroups = new HashSet<String>();
        for (SpacePermission spacePermission : this.spacePermissionManager.getGlobalPermissions()) {
            if (!"SYSTEMADMINISTRATOR".equals(spacePermission.getType()) || !spacePermission.isGroupPermission()) continue;
            adminGroups.add(spacePermission.getGroup());
        }
        if (adminGroups.contains(this.getName()) && adminGroups.size() == 1) {
            this.addActionError(this.getText("cannot.remove.last.group.with.admin.permission"));
        }
        return "input";
    }

    public String execute() throws Exception {
        Group groupToDelete = this.getGroup();
        if (TextUtils.stringSet((String)this.confirm) && this.permissionManager.hasPermission(this.getRemoteUser(), Permission.REMOVE, groupToDelete)) {
            this.userAccessor.removeGroup(groupToDelete);
        }
        return "success";
    }

    public List getGlobalPermissionsForThisGroup() {
        ArrayList<SpacePermission> result = new ArrayList<SpacePermission>();
        for (SpacePermission spacePermission : this.spacePermissionManager.getGlobalPermissions()) {
            if (!spacePermission.isGroupPermission() || !spacePermission.getGroup().equals(this.getGroup().getName())) continue;
            result.add(spacePermission);
        }
        return result;
    }

    public List getGroupSpacePermissionsForSpace(Space space) {
        ArrayList<SpacePermission> result = new ArrayList<SpacePermission>();
        for (SpacePermission spacePermission : space.getPermissions()) {
            if (!spacePermission.isGroupPermission() || !spacePermission.getGroup().equals(this.getGroup().getName())) continue;
            result.add(spacePermission);
        }
        return result;
    }

    public List getSpaces() {
        return this.spaceManager.getSpacesByType(SpaceType.GLOBAL);
    }

    public Pager getGroups() {
        Pager result = super.getGroups();
        ArrayList minusOneGroup = new ArrayList();
        while (result.iterator().hasNext()) {
            Object o = result.iterator().next();
            if (o.equals(this.getGroup())) continue;
            minusOneGroup.add(o);
        }
        return new DefaultPager(minusOneGroup);
    }

    public Pager getUsers() {
        return this.userAccessor.getMemberNames(this.getGroup());
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public SpaceManager getSpaceManager() {
        return this.spaceManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }
}

