/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import bucket.user.LicensingException;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.CaptchaAware;
import com.atlassian.confluence.security.CaptchaManager;
import com.atlassian.confluence.security.ExternalUserManagementAware;
import com.atlassian.confluence.util.SeraphUtils;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;

public class SignupAction
extends ConfluenceActionSupport
implements ExternalUserManagementAware,
CaptchaAware {
    public static final String ENGLISH_ANONYMOUS_USER = "anonymous";
    private String username;
    private String password;
    private String confirm;
    private String email;
    private String fullname;
    private CaptchaManager captchaManager;

    public String doDefault() throws Exception {
        if (!this.userAccessor.isLicensedToAddMoreUsers()) {
            this.addActionError(this.getText("not.licensed", Arrays.asList(this.getBootstrapManager().getWebAppContextPath() + "/administrators.action")));
        }
        this.allowPublicSignup();
        return "input";
    }

    public void validate() {
        super.validate();
        if (this.getText("anonymous.name").equalsIgnoreCase(this.username)) {
            this.addFieldError("username", this.getText("reserved.username"));
        } else if (ENGLISH_ANONYMOUS_USER.equalsIgnoreCase(this.username)) {
            this.addFieldError("username", this.getText("reserved.username"));
        }
        if (this.getText("anonymous.name").equalsIgnoreCase(this.fullname)) {
            this.addFieldError("fullname", this.getText("reserved.fullname"));
        } else if (ENGLISH_ANONYMOUS_USER.equalsIgnoreCase(this.fullname)) {
            this.addFieldError("fullname", this.getText("reserved.fullname"));
        }
        if (TextUtils.stringSet((String)this.getPassword()) && !this.getPassword().equals(this.getConfirm())) {
            this.addFieldError("confirm", this.getText("passwords.dontmatch"));
        }
    }

    protected boolean allowPublicSignup() {
        if (this.getGlobalSettings().isDenyPublicSignup()) {
            this.addActionError(this.getText("public.signup.disabled", Arrays.asList(this.getBootstrapManager().getWebAppContextPath() + "/administrators.action")));
            return false;
        }
        return true;
    }

    public String execute() throws Exception {
        if (!this.allowPublicSignup()) {
            return "input";
        }
        try {
            this.userAccessor.addUser(this.username, this.password, this.email, this.fullname, new String[]{"confluence-users"});
        }
        catch (LicensingException e) {
            this.addActionError(this.getText("not.licensed", new String[]{this.getBootstrapManager().getWebAppContextPath() + "/administrators.action"}));
            return "input";
        }
        SecurityConfigFactory.getInstance().getAuthenticator().login(ServletActionContext.getRequest(), ServletActionContext.getResponse(), this.username, this.password, true);
        return super.execute();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = TextUtils.stringSet((String)username) ? username.trim() : username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public User getUser() {
        return this.userAccessor.getUser(this.username);
    }

    public boolean isPermitted() {
        return true;
    }

    public void setCaptchaManager(CaptchaManager captchaManager) {
        this.captchaManager = captchaManager;
    }

    public CaptchaManager getCaptchaManager() {
        return this.captchaManager;
    }

    public String getLinkLoginURL(HttpServletRequest request) {
        return SeraphUtils.getLinkLoginURL(request);
    }
}

