/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.user.UsernameToUserTranslatingPaginationSupport;
import com.atlassian.confluence.user.actions.SearchUsersAction;
import com.atlassian.user.Group;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class UserPickerAction
extends SearchUsersAction {
    private static final int USERS_PER_PAGE = 10;
    private static final String SEARCH_BY_USER_DETAILS = "searchByUserDetails";
    private static final String SEARCH_BY_MEMBERSHIP = "searchByMembership";
    private String searchType;
    private String onPopupSubmit;
    protected String membersOfGroupTerm;

    public void validate() {
        if (!this.isEmailVisible()) {
            this.setEmailTerm("");
        }
        if (SEARCH_BY_USER_DETAILS.equals(this.getSearchType())) {
            super.validate();
        } else if (StringUtils.isEmpty((String)this.membersOfGroupTerm)) {
            this.addFieldError("membersOfGroupTerm", "no.group.specified.validation.error");
        } else if (this.userAccessor.getGroup(this.membersOfGroupTerm) == null) {
            this.addFieldError("membersOfGroupTerm", this.getText("group.does.not.exist.validation.error"));
        }
    }

    public String doDefault() throws Exception {
        this.setSearchType(SEARCH_BY_USER_DETAILS);
        return super.doDefault();
    }

    public String execute() throws Exception {
        if (SEARCH_BY_USER_DETAILS.equals(this.getSearchType())) {
            return this.doUserSearch();
        }
        Group group = this.userAccessor.getGroup(this.membersOfGroupTerm);
        if (group != null) {
            List memberNames = this.userAccessor.getMemberNamesAsList(group);
            this.paginationSupport = new UsernameToUserTranslatingPaginationSupport(10, this.paginationSupport.getStartIndexValue());
            ((UsernameToUserTranslatingPaginationSupport)this.paginationSupport).setUserAccessor(this.userAccessor);
            this.paginationSupport.setItems(memberNames);
        }
        return "success";
    }

    public String getSearchType() {
        return this.searchType;
    }

    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    public String getOnPopupSubmit() {
        return this.onPopupSubmit;
    }

    public void setOnPopupSubmit(String onPopupSubmit) {
        this.onPopupSubmit = onPopupSubmit;
    }

    public String getMembersOfGroupTerm() {
        return this.membersOfGroupTerm;
    }

    public void setMembersOfGroupTerm(String membersOfGroupTerm) {
        this.membersOfGroupTerm = membersOfGroupTerm;
    }
}

