/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.core.Administrative;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.UsernameToUserTranslatingPaginationSupport;
import com.atlassian.confluence.user.actions.AbstractEntityPaginationAction;
import com.atlassian.user.Group;
import java.util.List;

public class ViewMembersOfGroupAction
extends AbstractEntityPaginationAction
implements Administrative {
    private static final int USERS_PER_PAGE = 10;
    private String membersOfGroupTerm;

    public ViewMembersOfGroupAction() {
        this.paginationSupport = new UsernameToUserTranslatingPaginationSupport(10, 0);
    }

    public String execute() throws Exception {
        Group group = this.userAccessor.getGroup(this.membersOfGroupTerm);
        if (group != null) {
            List memberNames = this.userAccessor.getMemberNamesAsList(group);
            UsernameToUserTranslatingPaginationSupport usernameToUserPaginationSupport = (UsernameToUserTranslatingPaginationSupport)this.paginationSupport;
            usernameToUserPaginationSupport.setUserAccessor(this.userAccessor);
            this.paginationSupport.setItems(memberNames);
        }
        return "success";
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public String getMembersOfGroupTerm() {
        return this.membersOfGroupTerm;
    }

    public void setMembersOfGroupTerm(String membersOfGroupTerm) {
        this.membersOfGroupTerm = membersOfGroupTerm;
    }
}

