/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.providers.jira;

import com.opensymphony.module.propertyset.AbstractPropertySet;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class ConditionalPropertySet
extends AbstractPropertySet {
    private String condition;
    private PropertySet defaultPS;
    private PropertySet conditionalPS;

    public void init(Map config, Map args) {
        this.defaultPS = (PropertySet)args.get("default");
        this.conditionalPS = (PropertySet)args.get("conditional");
        this.condition = (String)args.get("condition");
    }

    public Collection getKeys(String prefix, int type) throws PropertyException {
        Collection result = this.conditionalPS.getKeys(prefix, type);
        result.addAll(this.defaultPS.getKeys(prefix, type));
        return result;
    }

    public int getType(String key) throws PropertyException {
        return this.getRelevantPS(key).getType(key);
    }

    public boolean exists(String key) throws PropertyException {
        return this.getRelevantPS(key).exists(key);
    }

    public void remove(String key) throws PropertyException {
        this.getRelevantPS(key).remove(key);
    }

    protected void setImpl(int type, String key, Object value) throws PropertyException {
        PropertySet target = this.defaultPS;
        if (this.conditionPasses(key)) {
            target = this.conditionalPS;
        }
        switch (type) {
            case 5: {
                target.setString(key, (String)value);
                return;
            }
            case 1: {
                target.setBoolean(key, ((Boolean)value).booleanValue());
                return;
            }
            case 2: {
                target.setInt(key, ((Number)value).intValue());
                return;
            }
            case 3: {
                target.setLong(key, ((Number)value).longValue());
                return;
            }
            case 4: {
                target.setDouble(key, ((Number)value).doubleValue());
                return;
            }
            case 6: {
                target.setText(key, (String)value);
                return;
            }
            case 7: {
                target.setDate(key, (Date)value);
                return;
            }
        }
        throw new PropertyException("Type with int value " + type + " is not currently supported");
    }

    protected Object get(int type, String key) throws PropertyException {
        PropertySet target = this.defaultPS;
        if (this.conditionPasses(key)) {
            target = this.conditionalPS;
        }
        switch (type) {
            case 5: {
                return target.getString(key);
            }
            case 1: {
                return target.getBoolean(key);
            }
            case 2: {
                return new Integer(target.getInt(key));
            }
            case 3: {
                return new Long(target.getLong(key));
            }
            case 4: {
                return new Double(target.getDouble(key));
            }
            case 6: {
                return target.getString(key);
            }
            case 7: {
                Date o = target.getDate(key);
                if (o instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)o;
                    return new Date(timestamp.getTime());
                }
                return o;
            }
        }
        throw new PropertyException("Type with int value " + type + " is not currently supported");
    }

    protected PropertySet getRelevantPS(String key) {
        if (this.conditionPasses(key)) {
            return this.conditionalPS;
        }
        return this.defaultPS;
    }

    protected boolean conditionPasses(String key) {
        return key.startsWith(this.condition);
    }
}

