/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.providers.jira;

import com.opensymphony.user.provider.jdbc.JDBCAccessProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Category;

public class JiraJdbcAccessProvider
extends JDBCAccessProvider {
    private static final Category log = Category.getInstance(JiraJdbcAccessProvider.class);

    public boolean init(Properties props) {
        boolean result = super.init(props);
        if (result) {
            this.userTable = props.getProperty("userTable");
            if (this.userTable == null) {
                this.userTable = "userbase";
            }
            if ((this.userName = props.getProperty("userName")) == null) {
                this.userName = "userName";
            }
            if ((this.userPassword = props.getProperty("userPassword")) == null) {
                this.userPassword = "password_hash";
            }
            if ((this.groupTable = props.getProperty("groupTable")) == null) {
                this.groupTable = "groupbase";
            }
            if ((this.groupName = props.getProperty("groupName")) == null) {
                this.groupName = "groupname";
            }
            if ((this.membershipTable = props.getProperty("membershipTable")) == null) {
                this.membershipTable = "membershipbase";
            }
            if ((this.membershipUserName = props.getProperty("membershipUserName")) == null) {
                this.membershipUserName = "user_name";
            }
            if ((this.membershipGroupName = props.getProperty("membershipGroupName")) == null) {
                this.membershipGroupName = "group_name";
            }
        }
        return result;
    }

    public boolean addToGroup(String username, String groupname) {
        boolean addedToGroup = false;
        try {
            Connection conn = this.ds.getConnection();
            PreparedStatement ps = conn.prepareStatement("INSERT INTO " + this.membershipTable + " (" + this.membershipUserName + ", " + this.membershipGroupName + ") VALUES (?, ?)");
            ps.setString(1, username);
            ps.setString(2, groupname);
            ps.executeUpdate();
            addedToGroup = true;
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            log.fatal((Object)("Could not add user [" + username + "] to group [" + groupname + "]"), (Throwable)e);
        }
        return addedToGroup;
    }

    public boolean inGroup(String username, String groupname) {
        boolean inGroup = false;
        try {
            Connection conn = this.ds.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + this.membershipTable + " WHERE " + this.membershipUserName + " = ? AND " + this.membershipGroupName + " = ?");
            ps.setString(1, username);
            ps.setString(2, groupname);
            ResultSet rs = ps.executeQuery();
            inGroup = rs.next();
            rs.close();
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            log.fatal((Object)("Could not determine if user [" + username + "] is in group [" + groupname + "]"), (Throwable)e);
        }
        return inGroup;
    }

    public boolean removeFromGroup(String username, String groupname) {
        boolean removedFromGroup = false;
        try {
            Connection conn = this.ds.getConnection();
            PreparedStatement ps = conn.prepareStatement("DELETE FROM " + this.membershipTable + " WHERE " + this.membershipUserName + " = ? AND " + this.membershipGroupName + " =?");
            ps.setString(1, username);
            ps.setString(2, groupname);
            int rows = ps.executeUpdate();
            if (rows == 1) {
                removedFromGroup = true;
            }
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            log.fatal((Object)("Could not detele user [" + username + "] from group [" + groupname + "]"), (Throwable)e);
        }
        return removedFromGroup;
    }
}

