/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.providers.jira;

import com.opensymphony.module.propertyset.AbstractPropertySet;
import com.opensymphony.module.propertyset.InvalidPropertyTypeException;
import com.opensymphony.module.propertyset.PropertyException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class JiraJdbcPropertySet
extends AbstractPropertySet {
    private static final Logger log = Logger.getLogger(JiraJdbcPropertySet.class);
    DataSource ds;
    String username;
    long userid;
    private static final String PROPERTY_ENTRY_TABLE = "propertyentry";
    private static Map tableMap = new HashMap();

    public void init(Map config, Map args) {
        this.username = (String)args.get("username");
        this.userid = (Long)args.get("userid");
        this.ds = (DataSource)args.get("datasource");
    }

    public Collection getKeys(String prefix, int type) throws PropertyException {
        if (prefix == null) {
            prefix = "";
        }
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            PreparedStatement ps = null;
            String sql = "SELECT PROPERTY_KEY FROM propertyentry WHERE PROPERTY_KEY LIKE ? AND propertyentry.ENTITY_NAME = 'OSUser' and propertyentry.ENTITY_ID = " + this.userid;
            if (type == 0) {
                ps = conn.prepareStatement(sql);
                ps.setString(1, prefix + "%");
            } else {
                sql = sql + " AND propertytype = ?";
                ps = conn.prepareStatement(sql);
                ps.setString(1, prefix + "%");
                ps.setInt(2, type);
            }
            ArrayList<String> list = new ArrayList<String>();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            rs.close();
            ps.close();
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (SQLException e) {
            throw new PropertyException(e.getMessage());
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public int getType(String key) throws PropertyException {
        Connection conn = null;
        int type = 0;
        try {
            conn = this.ds.getConnection();
            PreparedStatement ps = null;
            String sql = "SELECT propertytype FROM propertyentry WHERE PROPERTY_KEY = ? AND propertyentry.ENTITY_NAME = 'OSUser' and propertyentry.ENTITY_ID = " + this.userid;
            ps = conn.prepareStatement(sql);
            ps.setString(1, key);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                type = rs.getInt(1);
            }
            rs.close();
            ps.close();
            int n = type;
            return n;
        }
        catch (SQLException e) {
            throw new PropertyException(e.getMessage());
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public boolean exists(String key) throws PropertyException {
        Connection conn = null;
        boolean exists = false;
        try {
            conn = this.ds.getConnection();
            PreparedStatement ps = null;
            String sql = "SELECT PROPERTY_KEY FROM propertyentry WHERE PROPERTY_KEY = ? AND propertyentry.ENTITY_NAME = 'OSUser' and propertyentry.ENTITY_ID = " + this.userid;
            ps = conn.prepareStatement(sql);
            ps.setString(1, key);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                exists = true;
            }
            rs.close();
            ps.close();
            boolean bl = exists;
            return bl;
        }
        catch (SQLException e) {
            throw new PropertyException(e.getMessage());
        }
        finally {
            this.closeConnection(conn);
        }
    }

    protected Object get(int type, String key) throws PropertyException {
        String typeTable = (String)tableMap.get(new Integer(type));
        String sql = "SELECT " + typeTable + ".propertyvalue from " + PROPERTY_ENTRY_TABLE + ", " + typeTable + " where " + PROPERTY_ENTRY_TABLE + ".ID = " + typeTable + ".ID and " + PROPERTY_ENTRY_TABLE + ".ENTITY_NAME = 'OSUser' and " + PROPERTY_ENTRY_TABLE + ".ENTITY_ID = " + this.userid + " and " + PROPERTY_ENTRY_TABLE + ".PROPERTY_KEY = ?";
        Object o = null;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, key);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                switch (type) {
                    case 5: {
                        o = rs.getString(1);
                        break;
                    }
                    case 6: {
                        o = rs.getString(1);
                        break;
                    }
                    case 1: {
                        o = rs.getInt(1) == 1;
                        break;
                    }
                    case 2: {
                        o = new Integer(rs.getInt(1));
                        break;
                    }
                    case 3: {
                        o = new Long(rs.getLong(1));
                        break;
                    }
                    case 4: {
                        o = new Double(rs.getDouble(1));
                        break;
                    }
                    case 7: {
                        o = rs.getDate(1);
                        break;
                    }
                    default: {
                        throw new InvalidPropertyTypeException("JDBCPropertySet doesn't support this type yet.");
                    }
                }
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            log.error((Object)("SQL exception getting object for type: " + type + ", key: " + key), (Throwable)e);
            throw new PropertyException(e.getMessage());
        }
        catch (NumberFormatException e) {
            log.error((Object)("Number format exception getting object for type: " + type + ", key: " + key), (Throwable)e);
            throw new PropertyException(e.getMessage());
        }
        finally {
            this.closeConnection(conn);
        }
        return o;
    }

    public void remove(String key) throws PropertyException {
    }

    protected void setImpl(int type, String key, Object value) throws PropertyException {
    }

    private void closeConnection(Connection conn) {
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException e) {
            log.error((Object)"Could not close connection");
        }
    }

    static {
        tableMap.put(new Integer(1), "propertynumber");
        tableMap.put(new Integer(2), "propertynumber");
        tableMap.put(new Integer(3), "propertynumber");
        tableMap.put(new Integer(4), "propertydecimal");
        tableMap.put(new Integer(5), "propertystring");
        tableMap.put(new Integer(6), "propertytext");
        tableMap.put(new Integer(7), "propertydate");
    }
}

