/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.seraph.config.SecurityConfig;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;

public class AccessLogFilter
implements Filter {
    private FilterConfig config;
    Category log = Category.getInstance(AccessLogFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
        this.log.info((Object)"AccessLogFilter initialized. Format is: <user> <url> <starting memory free (kb)> +- <difference in free mem (kb)> <query time (ms)> <remote address>");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (this.log.isInfoEnabled()) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            String url = request.getRequestURL().toString();
            if (this.interestingURL(url)) {
                Principal user = ((SecurityConfig)this.config.getServletContext().getAttribute("seraph_config")).getAuthenticator().getUser(request, response);
                String username = user == null ? null : user.getName();
                long startMem = Runtime.getRuntime().freeMemory() >> 10;
                long t1 = System.currentTimeMillis();
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                long t2 = System.currentTimeMillis();
                long endMem = Runtime.getRuntime().freeMemory() >> 10;
                long memDiff = endMem - startMem;
                StringBuffer buf = new StringBuffer();
                buf.append(username == null ? "-" : username).append(" ");
                buf.append(url);
                buf.append(" ").append(startMem);
                if (memDiff > 0L) {
                    buf.append("+").append(memDiff);
                }
                if (memDiff < 0L) {
                    buf.append(memDiff);
                }
                buf.append(" ").append(t2 - t1);
                buf.append(" ").append(servletRequest.getRemoteAddr());
                this.log.info((Object)buf.toString());
                return;
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    private boolean interestingURL(String url) {
        return url != null && !url.endsWith(".gif") && !url.endsWith(".png") && !url.endsWith(".jpg") && !url.endsWith(".css") && !url.endsWith(".ico") && !url.endsWith(".js");
    }

    public void destroy() {
        this.config = null;
    }
}

