/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.core.db.JDBCUtils;
import com.atlassian.spring.container.ContainerManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class AncestorTableBuilder {
    private static Category log = Category.getInstance(AncestorTableBuilder.class);
    private List errors = new ArrayList();

    public void build(SessionFactory sessionFactory) {
        this.buildImpl(sessionFactory, null);
    }

    public void buildForSpace(SessionFactory sessionFactory, Space space) {
        this.buildImpl(sessionFactory, space);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void buildImpl(SessionFactory sessionFactory, Space space) {
        Session session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
        PreparedStatement ps = null;
        try {
            session.flush();
            Connection c = session.connection();
            String sqlDeleteQuery = "delete from CONFANCESTORS";
            if (space != null) {
                sqlDeleteQuery = sqlDeleteQuery + " where DESCENDENTID IN (" + StringUtils.join((Collection)this.getPageIdsInSpace(space), (String)", ") + ")";
            }
            ps = c.prepareStatement(sqlDeleteQuery);
            ps.execute();
            if (!session.connection().getAutoCommit()) {
                session.connection().commit();
            }
            session.clear();
            this.clearAncestorsCollectionCache();
            List pages = session.createQuery("from Page page where page.parent IS NOT NULL " + (space != null ? "and lower(page.space.key) = '" + space.getKey().toLowerCase() + "'" : "") + " order by page.id").list();
            int i = 0;
            for (Page page : pages) {
                page.getAncestors().addAll(this.getAncestry(page, new HashSet()));
                log.info((Object)("updating " + page.getTitle() + "[" + page.getId() + "]" + " (" + ++i + "/" + pages.size() + ")"));
                session.save((Object)page);
                if (i % 100 != 0) continue;
                session.flush();
            }
            session.flush();
        }
        catch (HibernateException e) {
            log.error((Object)"Error trying to build CONFANCESTORS table.", (Throwable)e);
            this.errors.add("Error trying to build CONFANCESTORS table.");
            JDBCUtils.close((Statement)ps);
        }
        catch (SQLException e2) {
            log.error((Object)"Error cleaning out the CONFANCESTORS table.", (Throwable)e2);
            this.errors.add("Error cleaning out the CONFANCESTORS table.");
            {
                catch (Throwable throwable) {
                    JDBCUtils.close(ps);
                    throw throwable;
                }
            }
            JDBCUtils.close((Statement)ps);
        }
        JDBCUtils.close((Statement)ps);
    }

    private List getPageIdsInSpace(Space space) {
        ArrayList<String> result = new ArrayList<String>();
        if (ContainerManager.isContainerSetup()) {
            PageManager pageManager = (PageManager)ContainerManager.getComponent((String)"pageManager");
            List pagesInSpace = pageManager.getPages(space, true);
            for (Page page : pagesInSpace) {
                result.add(page.getIdAsString());
            }
        }
        return result;
    }

    public List getErrors() {
        return this.errors;
    }

    private void clearAncestorsCollectionCache() {
        if (ContainerManager.isContainerSetup()) {
            log.info((Object)"Clearing ancestors cache ...");
            CacheFactory cacheFactory = (CacheFactory)ContainerManager.getComponent((String)"cacheFactory");
            if (cacheFactory != null) {
                try {
                    cacheFactory.getCache(Page.class.getName() + ".ancestors").removeAll();
                    log.info((Object)"Ancestors cache cleared.");
                    return;
                }
                catch (Exception e) {
                    log.error((Object)"Error cleaning out the ancestors collection cache during rebuild of CONFANCESTORS table.", (Throwable)e);
                }
            }
        }
    }

    private List getAncestry(Page page, Set visitedPages) {
        Page parent = page.getParent();
        if (parent == null) {
            return new ArrayList();
        }
        if (visitedPages.contains(parent)) {
            log.warn((Object)("Ancestor cycle detected at page " + page.getNameForComparison() + " with parent " + parent.getNameForComparison() + ". Breaking cycle."));
            page.setParentPage(null);
            return new ArrayList();
        }
        visitedPages.add(parent);
        List ancestry = this.getAncestry(parent, visitedPages);
        ancestry.add(page.getParent());
        return ancestry;
    }
}

