/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.confluence.util.classpath.ClasspathClasses;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public class ClasspathUtils {
    public static URL[] getSystemClasspath() {
        ClassLoader base = ClassLoader.getSystemClassLoader();
        if (base instanceof URLClassLoader) {
            return ((URLClassLoader)base).getURLs();
        }
        return null;
    }

    public static URL[] getThreadContextClasspath() {
        LinkedList<URL> threadContextClasspathUrls = new LinkedList<URL>();
        boolean urlClassLoaderFound = false;
        for (ClassLoader classLoader = Thread.currentThread().getContextClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            URL[] urls;
            if (!(classLoader instanceof URLClassLoader) || (urls = ((URLClassLoader)classLoader).getURLs()) == null) continue;
            threadContextClasspathUrls.addAll(Arrays.asList(urls));
            urlClassLoaderFound = true;
        }
        if (!urlClassLoaderFound) {
            return null;
        }
        return threadContextClasspathUrls.toArray(new URL[0]);
    }

    public static List getThreadContentClassLoaderHierarchy() {
        LinkedList<ClassLoader> classLoaders = new LinkedList<ClassLoader>();
        for (ClassLoader classLoader = Thread.currentThread().getContextClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            classLoaders.add(classLoader);
        }
        return classLoaders;
    }

    public static List getClassLoaderClasspath(ClassLoader classloader) {
        if (!(classloader instanceof URLClassLoader)) {
            return null;
        }
        return Arrays.asList(((URLClassLoader)classloader).getURLs());
    }

    public static List getClassesFromJar(URL jarUrl) {
        return ClasspathUtils.getFilesFromJar(jarUrl, true);
    }

    private static List getFilesFromJar(URL jarUrl, boolean onlyAddClasses) {
        JarInputStream jar;
        LinkedList<String> result = new LinkedList<String>();
        try {
            jar = new JarInputStream(jarUrl.openStream());
        }
        catch (IOException e) {
            return null;
        }
        try {
            ZipEntry entry = jar.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (onlyAddClasses) {
                    if (name.endsWith(".class")) {
                        result.add(name);
                    }
                } else {
                    result.add(name);
                }
                entry = jar.getNextEntry();
            }
        }
        catch (IOException e) {
            return result;
        }
        return result;
    }

    public static ClasspathClasses getClassesInClasspathJars() {
        URL[] jarUrls = ClasspathUtils.getThreadContextClasspath();
        if (jarUrls == null) {
            return null;
        }
        ClasspathClasses result = new ClasspathClasses();
        for (int i = 0; i < jarUrls.length; ++i) {
            URL jarUrl = jarUrls[i];
            List jarClassFileNames = ClasspathUtils.getClassesFromJar(jarUrl);
            if (jarClassFileNames == null) continue;
            result.addAll(jarUrl, jarClassFileNames);
        }
        return result;
    }

    public static ClasspathClasses getFilesInClasspathJars() {
        URL[] jarUrls = ClasspathUtils.getThreadContextClasspath();
        if (jarUrls == null) {
            return null;
        }
        ClasspathClasses result = new ClasspathClasses();
        for (int i = 0; i < jarUrls.length; ++i) {
            URL jarUrl = jarUrls[i];
            List jarClassFileNames = ClasspathUtils.getFilesFromJar(jarUrl, false);
            if (jarClassFileNames == null) continue;
            result.addAll(jarUrl, jarClassFileNames);
        }
        return result;
    }
}

