/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.EnumerationUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;

public class ClusterUtils {
    private static final String CONFLUENCE_ALLOW_LOOPBACK_CLUSTER = "confluence.allow.loopback.cluster";
    private static final NonLoopbackInterfacePredicate NON_LOOPBACK_INTERFACE_PREDICATE = new NonLoopbackInterfacePredicate();
    static final Predicate CLUSTERABLE_INTERFACE_PREDICATE = Boolean.getBoolean("confluence.allow.loopback.cluster") ? PredicateUtils.truePredicate() : NON_LOOPBACK_INTERFACE_PREDICATE;

    private ClusterUtils() {
    }

    public static InetAddress hashNameToAddress(String name) {
        byte[] hash = ClusterUtils.hashName(name);
        byte[] addrBytes = new byte[]{hash[0], hash[1], hash[2], hash[3]};
        return ClusterUtils.getAddress(addrBytes);
    }

    public static InetAddress hashNameToMulticastAddress(String name) {
        InetAddress addr = ClusterUtils.hashNameToAddress(name);
        byte[] addrBytes = addr.getAddress();
        addrBytes[0] = (byte)(addrBytes[0] | 0xFFFFFFE0);
        addrBytes[0] = (byte)(addrBytes[0] & 0xFFFFFFEF);
        if (addrBytes[0] == -17) {
            addrBytes[0] = -18;
        }
        if (!(addr = ClusterUtils.getAddress(addrBytes)).isMCLinkLocal()) {
            return addr;
        }
        addrBytes[3] = 1;
        return ClusterUtils.getAddress(addrBytes);
    }

    public static Iterator getClusterableInterfaces() throws SocketException {
        return IteratorUtils.filteredIterator((Iterator)IteratorUtils.asIterator(NetworkInterface.getNetworkInterfaces()), (Predicate)CLUSTERABLE_INTERFACE_PREDICATE);
    }

    public static boolean isLoopbackInterface(NetworkInterface iface) {
        return !NON_LOOPBACK_INTERFACE_PREDICATE.evaluate(iface);
    }

    private static byte[] hashName(String name) {
        MessageDigest md5Digest = null;
        try {
            md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 hashing not supported", e);
        }
        byte[] hash = null;
        try {
            hash = md5Digest.digest(name.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return hash;
    }

    private static InetAddress getAddress(byte[] addrBytes) {
        InetAddress addr = null;
        try {
            addr = InetAddress.getByAddress(addrBytes);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        return addr;
    }

    private static class LoopbackAddressPredicate
    implements Predicate {
        private LoopbackAddressPredicate() {
        }

        public boolean evaluate(Object object) {
            InetAddress address = (InetAddress)object;
            return address.isLoopbackAddress();
        }
    }

    private static class NonLoopbackInterfacePredicate
    implements Predicate {
        private static final Predicate NON_LOOPBACK_ADDRESS_PREDICATE = PredicateUtils.notPredicate((Predicate)new LoopbackAddressPredicate());

        private NonLoopbackInterfacePredicate() {
        }

        public boolean evaluate(Object object) {
            NetworkInterface networkInterface = (NetworkInterface)object;
            List addresses = EnumerationUtils.toList(networkInterface.getInetAddresses());
            return CollectionUtils.exists((Collection)addresses, (Predicate)NON_LOOPBACK_ADDRESS_PREDICATE);
        }
    }
}

