/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.opensymphony.util.TextUtils;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class CompleteURLEncoder {
    public static final Logger log = Logger.getLogger(CompleteURLEncoder.class);
    public static final String FILE_PROTOCOL = "file";

    public static String encode(String urlString, String enc) throws MalformedURLException, UnsupportedEncodingException {
        log.debug((Object)urlString);
        URL url = new URL(urlString);
        if (FILE_PROTOCOL.equals(url.getProtocol())) {
            return CompleteURLEncoder.fileEncode(url);
        }
        return CompleteURLEncoder.httpEncode(url, enc);
    }

    private static String fileEncode(URL url) throws MalformedURLException {
        try {
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), null, null);
            URL encodedUrl = uri.toURL();
            log.debug((Object)encodedUrl);
            if (!TextUtils.stringSet((String)url.getHost())) {
                return "file://" + encodedUrl.getPath();
            }
            return encodedUrl.toString();
        }
        catch (URISyntaxException e) {
            log.error((Object)("Error while encoding file url: " + url), (Throwable)e);
            return url.toString();
        }
    }

    private static String httpEncode(URL url, String enc) throws MalformedURLException, UnsupportedEncodingException {
        try {
            boolean hasQueryString;
            String query = url.getQuery();
            StringBuffer stringBuffer = null;
            if (TextUtils.stringSet((String)query)) {
                stringBuffer = new StringBuffer();
                StringTokenizer st = new StringTokenizer(query, "&");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    String[] tokens = token.split("=");
                    if (tokens != null && tokens.length == 2) {
                        stringBuffer.append(URLEncoder.encode(tokens[0], enc)).append("=").append(URLEncoder.encode(tokens[1], enc));
                    } else {
                        stringBuffer.append(URLEncoder.encode(token, enc));
                    }
                    if (!st.hasMoreTokens()) continue;
                    stringBuffer.append("&");
                }
            }
            String urlString = url.toString();
            int fragmentIndex = urlString.indexOf("#");
            boolean bl = hasQueryString = stringBuffer != null;
            if (fragmentIndex != -1) {
                if (!hasQueryString) {
                    stringBuffer = new StringBuffer();
                }
                String fragment = urlString.substring(fragmentIndex + 1, urlString.length());
                stringBuffer.append("#");
                stringBuffer.append(fragment);
            }
            String queryParam = null;
            if (hasQueryString) {
                queryParam = "";
            }
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), queryParam, null);
            URL encodedUrl = uri.toURL();
            String returnUrl = encodedUrl.toString();
            StringBuffer total = new StringBuffer(returnUrl);
            if (stringBuffer != null) {
                total.append(stringBuffer);
            }
            log.debug((Object)("encoded http url: " + returnUrl));
            return total.toString();
        }
        catch (URISyntaxException e) {
            log.error((Object)("Error while encoding http url: " + url), (Throwable)e);
            return url.toString();
        }
    }
}

