/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.themes.ColorSchemeBean;
import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.themes.ColourSchemeManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.spring.container.ContainerManager;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public final class ConfluenceRenderUtils {
    private static final Logger LOG = Logger.getLogger(ConfluenceRenderUtils.class);

    public static String getAttachmentsRemotePath(PageContext context) {
        if (context == null) {
            return null;
        }
        return ConfluenceRenderUtils.getAttachmentRemotePath(context.getEntity());
    }

    public static String getAttachmentRemotePath(Attachment a) {
        if (a == null) {
            return null;
        }
        return ConfluenceRenderUtils.getAttachmentRemotePath(a.getContent());
    }

    public static String getAttachmentRemotePath(ContentEntityObject content) {
        if (content == null) {
            return null;
        }
        BootstrapManager bootstrapManager = (BootstrapManager)BootstrapUtils.getBootstrapManager();
        return bootstrapManager.getWebAppContextPath() + "/download/attachments/" + content.getId();
    }

    public static String getAbsoluteAttachmentRemotePath(Attachment a) {
        if (a == null) {
            return null;
        }
        ContentEntityObject content = a.getContent();
        if (content == null) {
            return null;
        }
        return GeneralUtil.getGlobalSettings().getBaseUrl() + "/download/attachments/" + content.getId();
    }

    public static String renderDefaultStylesheet() {
        return ConfluenceRenderUtils.renderSpaceStylesheet(null);
    }

    public static String renderSpaceStylesheet(Space space) {
        ColourSchemeManager colourSchemeManager = (ColourSchemeManager)ContainerManager.getComponent((String)"colourSchemeManager");
        ColourScheme colourScheme = colourSchemeManager.getGlobalColourScheme();
        if (space != null) {
            colourScheme = colourSchemeManager.getSpaceColourScheme(space);
        }
        VelocityContext context = new VelocityContext();
        context.put("webResourceManager", ContainerManager.getComponent((String)"webResourceManager"));
        context.put("colorScheme", (Object)new ColorSchemeBean(colourScheme));
        return VelocityUtils.getRenderedTemplate("/styles/default-inline-css.vm", (Context)context);
    }
}

