/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.PageContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.links.linktypes.ShortcutLink;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.UrlLink;
import com.atlassian.renderer.util.RendererUtil;
import com.atlassian.trackback.Trackback;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConfluenceTrackbackUtils {
    public static String getContentIdentifier(ContentEntityObject entity) {
        return GeneralUtil.getGlobalSettings().getBaseUrl() + entity.getUrlPath();
    }

    public static String getPingUrl(ContentEntityObject entity) {
        return GeneralUtil.getGlobalSettings().getBaseUrl() + "/rpc/trackback/" + entity.getId();
    }

    public static Trackback makeTrackback(ContentEntityObject entity) {
        Trackback tb = new Trackback();
        if (entity instanceof SpaceContentEntityObject) {
            SpaceContentEntityObject spaceContentEntityObject = (SpaceContentEntityObject)entity;
            tb.setBlogName("Confluence: " + spaceContentEntityObject.getSpace().getName());
        } else if (entity instanceof PageContentEntityObject) {
            PageContentEntityObject pageContentEntityObject = (PageContentEntityObject)entity;
            tb.setBlogName("Confluence: " + pageContentEntityObject.getPage().getSpace().getName());
        } else {
            tb.setBlogName("Confluence");
        }
        tb.setTitle(entity.getTitle());
        tb.setUrl(ConfluenceTrackbackUtils.getContentIdentifier(entity));
        tb.setExcerpt(RendererUtil.summarise((String)entity.getContent()));
        return tb;
    }

    public static Set getUrlsFromLinks(List outgoingLinks) {
        HashSet<String> urls = new HashSet<String>();
        for (Link link : outgoingLinks) {
            if (!(link instanceof ShortcutLink) && !(link instanceof UrlLink) || !link.getUrl().toLowerCase().startsWith("http")) continue;
            urls.add(link.getUrl());
        }
        return urls;
    }
}

