/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.cache.CacheManagerKeys;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import com.atlassian.spring.container.ContainerManager;

public class DefaultUserChecker
implements UserChecker {
    private CacheFactory cacheFactory;
    private LicenseCalculationThread licenseCalculationThread;
    protected static final int UNLIMITED_USER_THRESHOLD = 9999;
    private static final String THREAD_NAME = "confluence-license-calc-thread";

    public int getNumberOfRegisteredUsers() {
        return this.getNumberOfRegisteredUsers(3);
    }

    public int getNumberOfRegisteredUsers(int retries) {
        if (this.isUnlimitedUserLicense()) {
            return -2;
        }
        if (this.cacheFactory == null) {
            this.getUserAccessor().getUsersWithConfluenceAccessAsList().size();
        }
        if (retries == 0) {
            return -1;
        }
        Integer cachedResult = null;
        try {
            cachedResult = (Integer)this.getCache().get((Object)"too.many.users.result");
        }
        catch (Exception e) {
            log.error((Object)"Error result from cache.", (Throwable)e);
        }
        if (cachedResult != null) {
            return cachedResult;
        }
        this.determineRegisteredUsersInBackgroundThread();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            log.info((Object)"Thread sleep interrupted.", (Throwable)e);
        }
        return this.getNumberOfRegisteredUsers(--retries);
    }

    public boolean hasTooManyUsers() {
        if (!ContainerManager.isContainerSetup()) {
            return false;
        }
        License license = this.getLicense();
        if (this.isUnlimitedUserLicense(license)) {
            return false;
        }
        return this.getNumberOfRegisteredUsers() > this.getLicense().getUsers();
    }

    public boolean isUnlimitedUserLicense() {
        return this.isUnlimitedUserLicense(this.getLicense());
    }

    public boolean isUnlimitedUserLicense(License license) {
        return license.getUsers() > 9999;
    }

    public boolean isLicensedToAddMoreUsers() {
        boolean licensed;
        if (!ContainerManager.isContainerSetup()) {
            return false;
        }
        License license = this.getLicense();
        if (this.isUnlimitedUserLicense(license)) {
            return true;
        }
        boolean bl = licensed = this.getNumberOfRegisteredUsers() < license.getUsers();
        if (!licensed) {
            log.info((Object)("Not licensed to add more users. Registered users: " + this.getNumberOfRegisteredUsers() + " licensed users: " + license.getUsers()));
        }
        return licensed;
    }

    private License getLicense() {
        License license = LicenseManager.getInstance().getLicense("CONF");
        if (license != null) {
            return license;
        }
        throw new RuntimeException("Huh? License is null?");
    }

    public void resetResult() {
        try {
            this.getCache().removeAll();
        }
        catch (Exception e) {
            log.error((Object)"Error resetting cache.", (Throwable)e);
        }
    }

    private Cache getCache() {
        return this.cacheFactory.getCache(CacheManagerKeys.CACHE_KEY_USER_CHECKER);
    }

    private synchronized void determineRegisteredUsersInBackgroundThread() {
        if (this.isRunning()) {
            return;
        }
        this.licenseCalculationThread = new LicenseCalculationThread();
        Thread t = new Thread(this.licenseCalculationThread);
        t.setName(THREAD_NAME);
        t.start();
    }

    public boolean isRunning() {
        return this.licenseCalculationThread != null && this.licenseCalculationThread.isRunning();
    }

    public void incrementRegisteredUserCount() {
        License license = this.getLicense();
        if (this.isUnlimitedUserLicense(license)) {
            return;
        }
        if (this.getNumberOfRegisteredUsers() > 0) {
            this.getCache().put((Object)"too.many.users.result", (Object)new Integer(this.getNumberOfRegisteredUsers() + 1));
        }
    }

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    public UserAccessor getUserAccessor() {
        return (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
    }

    private class LicenseCalculationThread
    implements Runnable {
        private boolean running;

        private LicenseCalculationThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.running = true;
                DefaultUserChecker.this.getCache().put((Object)"too.many.users.result", (Object)new Integer(DefaultUserChecker.this.getUserAccessor().getUsersWithConfluenceAccessAsList().size()));
            }
            catch (Exception exception) {
            }
            finally {
                this.running = false;
            }
        }

        public boolean isRunning() {
            return this.running;
        }
    }
}

