/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.util.DiffResult;
import com.atlassian.confluence.util.GeneralUtil;
import com.opensymphony.util.TextUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.jrcs.diff.AddDelta;
import org.apache.commons.jrcs.diff.ChangeDelta;
import org.apache.commons.jrcs.diff.DeleteDelta;
import org.apache.commons.jrcs.diff.Delta;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.commons.jrcs.diff.MergeVisitor;
import org.apache.commons.jrcs.diff.Revision;
import org.apache.commons.jrcs.diff.RevisionVisitor;
import org.apache.log4j.Logger;

public class DiffUtils {
    private static Logger log = Logger.getLogger(DiffUtils.class);
    public static final byte WORD_DIFF_MAX = 60;
    public static final byte DIFF_MODE_NONE = -1;
    public static final byte DIFF_MODE_ADD = 0;
    public static final byte DIFF_MODE_DELETE = 1;
    public static final byte DIFF_MODE_CHANGE_DELETE = 2;
    public static final byte DIFF_MODE_CHANGE_ADD = 3;
    public static final String STYLE_NONE = "";
    public static final String STYLE_ADDED = "diffaddedchars";
    public static final String STYLE_DELETED = "diffremovedchars";
    public static final String STYLE_ERROR = "differror";
    private static byte diffMode = (byte)-1;

    public static DiffResult generateDiff(ContentEntityObject originalPage, ContentEntityObject revisedPage) throws DifferentiationFailedException {
        StringBuffer diffBuffer = new StringBuffer(revisedPage.getContent().length());
        Object[] originalFile = DiffUtils.loadPage(originalPage);
        Object[] revisedFile = DiffUtils.loadPage(revisedPage);
        Revision revision = null;
        if (originalFile.length == 0 && revisedFile.length == 0) {
            DiffUtils.addLine(diffBuffer, STYLE_NONE);
        } else {
            Diff df = new Diff(originalFile);
            revision = df.diff(revisedFile);
            log.debug((Object)("revision = " + revision));
            for (int i = 0; i <= originalFile.length; ++i) {
                Delta relevantDelta;
                Object o = null;
                if (i < originalFile.length) {
                    o = originalFile[i];
                }
                if ((relevantDelta = DiffUtils.getRelevantDelta(revision, i)) == null) {
                    if (o == null) continue;
                    DiffUtils.addLine(diffBuffer, o);
                    continue;
                }
                if (relevantDelta instanceof AddDelta) {
                    DiffUtils.printAddedLines(diffBuffer, originalFile, revisedFile, relevantDelta, revision);
                    if (o == null) continue;
                    DiffUtils.addLine(diffBuffer, o);
                    continue;
                }
                if (relevantDelta instanceof DeleteDelta) {
                    DiffUtils.printDeletedLines(diffBuffer, originalFile, revisedFile, relevantDelta, revision);
                    i = relevantDelta.getOriginal().last();
                    continue;
                }
                if (relevantDelta instanceof ChangeDelta) {
                    DiffUtils.printChangedLines(diffBuffer, originalFile, revisedFile, relevantDelta, revision);
                    i = relevantDelta.getOriginal().last();
                    continue;
                }
                log.error((Object)("Error!! Unknown delta" + relevantDelta));
                if (o == null) continue;
                DiffUtils.addLine(diffBuffer, o, STYLE_ERROR);
            }
        }
        return new DiffResult(diffBuffer.toString(), revision);
    }

    private static void addLine(StringBuffer buffer, Object o) {
        DiffUtils.addLine(buffer, o, "diffnochange");
    }

    private static void addLine(StringBuffer buffer, Object o, String style) {
        DiffUtils.addLine(buffer, o, style, null, null);
    }

    private static void addLine(StringBuffer buffer, Object o, String style, Delta relevantDelta, Revision revision) {
        String domainName = GeneralUtil.getGlobalSettings().getBaseUrl();
        if (style != null) {
            buffer.append("<tr>");
            if (relevantDelta != null) {
                int deltaIndex = DiffUtils.getDeltaIndex(relevantDelta, revision);
                buffer.append("<td valign='top' class='diffnav' width='1%'>");
                buffer.append("<a name='change").append(deltaIndex).append("'></a>");
                if (deltaIndex > 0 && DiffUtils.isOriginalLineFromChangeDelta(style, relevantDelta)) {
                    buffer.append("<a href='#change").append(deltaIndex - 1).append("' title='Previous change'><img src='").append(domainName).append("/images/icons/nav_up.gif' border='0' width='16' height='16' hspace='1' vspace='1'></a>");
                } else {
                    buffer.append("&nbsp;");
                }
                buffer.append("</td><td valign='top' class='diffnav' width='1%'>");
                if (deltaIndex < revision.size() - 1 && DiffUtils.isOriginalLineFromChangeDelta(style, relevantDelta)) {
                    buffer.append("<a href='#change").append(deltaIndex + 1).append("' title='Next change'><img src='").append(domainName).append("/images/icons/nav_down.gif' border='0' width='16' height='16' hspace='1' vspace='1'></a>");
                } else {
                    buffer.append("&nbsp;");
                }
            } else {
                buffer.append("<td colspan='2' class='diffnav'>&nbsp;</td>");
            }
            buffer.append("<td class=\"").append(style).append("\">");
        }
        if (STYLE_NONE.equals(o.toString().trim())) {
            buffer.append("&nbsp;");
        } else {
            buffer.append(o.toString());
        }
        if (style != null) {
            buffer.append("</td></tr>");
        }
        buffer.append(System.getProperty("line.separator"));
    }

    private static boolean isOriginalLineFromChangeDelta(String style, Delta delta) {
        if (delta instanceof ChangeDelta) {
            return "diffdeleted".equals(style);
        }
        return true;
    }

    private static int getDeltaIndex(Delta relevantDelta, Revision revision) {
        if (relevantDelta == null) {
            return -1;
        }
        for (int i = 0; i < revision.size(); ++i) {
            if (!relevantDelta.equals(revision.getDelta(i))) continue;
            return i;
        }
        return -1;
    }

    private static void printChangedLines(StringBuffer buffer, Object[] originalFile, Object[] revisedFile, Delta relevantDelta, Revision revision) {
        try {
            DiffUtils.setDiffMode((byte)2);
            DiffUtils.printDeletedLines(buffer, originalFile, revisedFile, relevantDelta, revision);
            DiffUtils.setDiffMode((byte)3);
            DiffUtils.printAddedLines(buffer, originalFile, revisedFile, relevantDelta, revision);
        }
        catch (DifferentiationFailedException e) {
            log.warn((Object)"Error printing changed lines", (Throwable)e);
        }
        DiffUtils.setDiffMode((byte)-1);
    }

    private static void printDeletedLines(StringBuffer buffer, Object[] originalFile, Object[] revisedFile, Delta relevantDelta, Revision revision) throws DifferentiationFailedException {
        DiffUtils.setDiffMode((byte)1);
        int x = 0;
        for (int i = relevantDelta.getOriginal().first(); i <= relevantDelta.getOriginal().last(); ++i) {
            String line;
            if (revisedFile.length > i && relevantDelta.getRevised().size() > x) {
                String o = relevantDelta.getOriginal().chunk().get(x).toString();
                String r = relevantDelta.getRevised().chunk().get(x).toString();
                line = DiffUtils.diffLine(o, r);
            } else {
                line = originalFile[i].toString();
            }
            if (x == 0) {
                DiffUtils.addLine(buffer, line, "diffdeleted", relevantDelta, revision);
            } else {
                DiffUtils.addLine(buffer, line, "diffdeleted");
            }
            ++x;
        }
        DiffUtils.setDiffMode((byte)-1);
    }

    private static void printAddedLines(StringBuffer buffer, Object[] originalFile, Object[] revisedFile, Delta relevantDelta, Revision revision) throws DifferentiationFailedException {
        DiffUtils.setDiffMode((byte)0);
        int x = 0;
        int i = relevantDelta.getRevised().first();
        while (i <= relevantDelta.getRevised().last()) {
            String line;
            if (originalFile.length > i && relevantDelta.getOriginal().size() > x) {
                String o = relevantDelta.getOriginal().chunk().get(x).toString();
                String r = relevantDelta.getRevised().chunk().get(x).toString();
                line = DiffUtils.diffLine(r, o);
            } else {
                line = revisedFile[i].toString();
            }
            if (x == 0) {
                DiffUtils.addLine(buffer, line, "diffadded", relevantDelta, revision);
            } else {
                DiffUtils.addLine(buffer, line, "diffadded");
            }
            ++i;
            ++x;
        }
        DiffUtils.setDiffMode((byte)-1);
    }

    private static Delta getRelevantDelta(Revision revision, int line) {
        for (int i = 0; i < revision.size(); ++i) {
            Delta d = revision.getDelta(i);
            if ((d instanceof DeleteDelta || d instanceof ChangeDelta) && d.getOriginal().first() <= line && d.getOriginal().last() >= line) {
                return d;
            }
            if (!(d instanceof AddDelta) || d.getOriginal().first() != line) continue;
            return d;
        }
        return null;
    }

    public static Object[] loadPage(ContentEntityObject page) {
        String content = page.getContent();
        BufferedReader data = new BufferedReader(new StringReader(content));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String s;
            while ((s = data.readLine()) != null) {
                lines.add(TextUtils.htmlEncode((String)s));
            }
        }
        catch (IOException e) {
            log.error((Object)("Error reading page content" + e), (Throwable)e);
            return null;
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static String diffLine(String orig, String rev) throws DifferentiationFailedException {
        int delPercent;
        StringBuffer diffBuffer = new StringBuffer(rev.length());
        Object[] originalLine = DiffUtils.loadLine(orig);
        Object[] revisedLine = DiffUtils.loadLine(rev);
        int addedCount = 0;
        int removedCount = 0;
        if (originalLine.length == 0 && revisedLine.length == 0) {
            DiffUtils.addWord(diffBuffer, STYLE_NONE, STYLE_NONE);
        } else {
            Diff df = new Diff(originalLine);
            Revision revision = df.diff(revisedLine);
            for (int counter = 0; counter <= originalLine.length; ++counter) {
                String word;
                Delta relevantDelta;
                Object o = null;
                if (counter < originalLine.length) {
                    o = originalLine[counter];
                }
                if ((relevantDelta = DiffUtils.getRelevantDelta(revision, counter)) == null) {
                    if (o == null) continue;
                    DiffUtils.addWord(diffBuffer, o, STYLE_NONE);
                    continue;
                }
                if (relevantDelta instanceof AddDelta) {
                    if (DiffUtils.getDiffMode() == 1) {
                        word = relevantDelta.getRevised().toString();
                        addedCount += word.length();
                        DiffUtils.addWord(diffBuffer, word, STYLE_ADDED);
                    }
                    if (o == null) continue;
                    DiffUtils.addWord(diffBuffer, o, STYLE_NONE);
                    continue;
                }
                if (relevantDelta instanceof ChangeDelta || relevantDelta instanceof DeleteDelta) {
                    word = relevantDelta.getOriginal().toString();
                    if (DiffUtils.getDiffMode() == 1 || DiffUtils.getDiffMode() == 3) {
                        addedCount += word.length();
                        DiffUtils.addWord(diffBuffer, word, STYLE_ADDED);
                    } else if (DiffUtils.getDiffMode() == 2) {
                        removedCount += word.length();
                        DiffUtils.addWord(diffBuffer, word, STYLE_DELETED);
                    }
                    counter = relevantDelta.getOriginal().last();
                    continue;
                }
                log.error((Object)("Error!! Unknown delta" + relevantDelta));
                if (o == null) continue;
                DiffUtils.addWord(diffBuffer, o, STYLE_ERROR);
            }
        }
        int len = orig.length();
        int addPercent = len == 0 ? 100 : addedCount * 100 / len;
        int n = delPercent = len == 0 ? 0 : removedCount * 100 / len;
        if (addPercent > 60 || delPercent > 60) {
            return orig;
        }
        return diffBuffer.toString();
    }

    private static String[] loadLine(String line) {
        StringTokenizer st = new StringTokenizer(line, " ");
        String[] words = new String[st.countTokens()];
        for (int i = 0; i < words.length; ++i) {
            words[i] = st.nextToken() + " ";
        }
        return words;
    }

    private static void addWord(StringBuffer buffer, Object o, String style) {
        if (STYLE_NONE.equals(style)) {
            buffer.append(o.toString());
            return;
        }
        String trailingSpace = " ";
        if (!o.toString().endsWith(" ")) {
            trailingSpace = STYLE_NONE;
        }
        buffer.append("<span class=\"").append(style).append("\">").append(o.toString().trim()).append("</span>").append(trailingSpace);
    }

    public static byte getDiffMode() {
        return diffMode;
    }

    public static void setDiffMode(byte mode) {
        if (diffMode != 3 && diffMode != 2) {
            diffMode = mode;
        } else if (mode == -1 || mode == 3 || mode == 2) {
            diffMode = mode;
        }
    }

    public static String mergeChanges(String originalPage, String revisionA, String revisionB) {
        try {
            Object[] originalContent = DiffUtils.splitUpPage(originalPage);
            Object[] revisedContentA = DiffUtils.splitUpPage(revisionA);
            Object[] revisedContentB = DiffUtils.splitUpPage(revisionB);
            Revision revA = Diff.diff((Object[])originalContent, (Object[])revisedContentA);
            Revision revB = Diff.diff((Object[])originalContent, (Object[])revisedContentB);
            MergeVisitor visitor = new MergeVisitor();
            visitor.init(originalContent);
            revA.accept((RevisionVisitor)visitor);
            revB.accept((RevisionVisitor)visitor);
            if (visitor.wasConflictDetected()) {
                return null;
            }
            Object[] mergedContent = revB.patch(revA.patch(originalContent));
            return DiffUtils.reconstructPage(mergedContent);
        }
        catch (Exception e) {
            if (log.isInfoEnabled()) {
                log.info((Object)DiffUtils.getMergeErrorMessage(originalPage, revisionA, revisionB), (Throwable)e);
            }
            return null;
        }
    }

    private static String getMergeErrorMessage(String originalPage, String revisionA, String revisionB) {
        return "Error merging: original:'" + originalPage + "', revisionA:'" + revisionA + "', revisionB:'" + revisionB + "'";
    }

    private static String reconstructPage(Object[] words) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < words.length; ++i) {
            buffer.append(words[i]);
        }
        return buffer.toString();
    }

    private static Object[] splitUpPage(String content) {
        try {
            List words = DiffUtils.splitContentIntoWords(content);
            return words.toArray(new String[words.size()]);
        }
        catch (IOException e) {
            log.error((Object)("Error reading page content" + e), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List splitContentIntoWords(String content) throws IOException {
        BufferedReader data = null;
        try {
            String line;
            data = new BufferedReader(new StringReader(content));
            ArrayList<String> words = new ArrayList<String>();
            while ((line = data.readLine()) != null) {
                words.addAll(DiffUtils.splitLineIntoWords(line));
                words.add("\n");
            }
            ArrayList<String> arrayList = words;
            return arrayList;
        }
        finally {
            if (data != null) {
                try {
                    data.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static List splitLineIntoWords(String line) {
        ArrayList<String> words = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(line, " ", true);
        while (st.hasMoreTokens()) {
            words.add(st.nextToken());
        }
        return words;
    }
}

