/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import java.io.File;
import java.io.IOException;

public class FileNameEncodingTester {
    public static final String TEST_STRING = "I\u00f1t\u00ebrn\u00e2ti\u00f4n\u00e0liz\u00e6ti\u00f8n";
    public static final String TEST_STRING_CHANGED = "I\u00f1t\u00ebrn\u00e2ti\u00f4n\u00e0liz\u00e6ti\u00f9n";
    private boolean fileNameMangled = false;
    private Throwable fileCreationException = null;
    private boolean fileCreationSuccessful = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileNameEncodingTester(File testDir) {
        File encodingTestFile = null;
        if (!testDir.exists()) {
            throw new IllegalArgumentException(testDir + "does not exist");
        }
        if (!testDir.isDirectory()) {
            throw new IllegalArgumentException(testDir + "is not a directory");
        }
        try {
            File alternateFile = new File(testDir, TEST_STRING_CHANGED);
            encodingTestFile = new File(testDir, TEST_STRING);
            encodingTestFile.createNewFile();
            this.fileNameMangled = alternateFile.exists();
        }
        catch (IOException e) {
            this.fileCreationException = e;
        }
        finally {
            if (encodingTestFile != null && encodingTestFile.exists()) {
                this.fileCreationSuccessful = true;
                encodingTestFile.delete();
            }
        }
    }

    public boolean isFileNameMangled() {
        return this.fileNameMangled;
    }

    public Throwable getFileCreationException() {
        return this.fileCreationException;
    }

    public boolean isFileCreationSuccessful() {
        return this.fileCreationSuccessful;
    }
}

