/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.bonnie.search.summary.Summarizer;
import com.atlassian.bonnie.search.summary.Summary;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.languages.DefaultLocaleManager;
import com.atlassian.confluence.languages.LanguageManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.DefaultBootstrapManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.confluence.util.CompleteURLEncoder;
import com.atlassian.confluence.util.FontManager;
import com.atlassian.confluence.util.PlainTextToHtmlConverter;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.confluence.util.zip.FileUnzipper;
import com.atlassian.confluence.util.zip.UrlUnzipper;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.core.bean.MathBean;
import com.atlassian.core.util.FileSize;
import com.atlassian.core.util.PropertyUtils;
import com.atlassian.core.util.XMLUtils;
import com.atlassian.core.util.bean.ImageInfo;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import com.atlassian.license.LicenseUtils;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.renderer.util.RendererUtil;
import com.atlassian.renderer.util.UrlUtil;
import com.atlassian.seraph.cookie.CookieFactory;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.webwork.ServletActionContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.MailDateFormat;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class GeneralUtil {
    private static final Logger log = Logger.getLogger(GeneralUtil.class);
    private static String versionNumber;
    private static Date buildDate;
    private static String buildNumber;
    private static String buildPartner;
    private static String buildExcludedLocale;
    private static Long systemStartupTime;
    private static final String EMAIL_PATTERN_STRING = "([\\w-%\\+\\.]+@[\\w-%\\.]+\\.[\\p{Alpha}]+)";
    private static final Pattern EMAIL_PATTERN;
    private static UserAccessor userAccessor;
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final int HTTPS_DEFAULT_PORT = 443;

    private static void hackUrlEncoder() {
        try {
            Field dontNeedEncodingField = URLEncoder.class.getDeclaredField("dontNeedEncoding");
            dontNeedEncodingField.setAccessible(true);
            BitSet dontNeedEncoding = (BitSet)dontNeedEncodingField.get(URLEncoder.class);
            dontNeedEncoding.set(126);
            dontNeedEncoding.set(64);
        }
        catch (Throwable t) {
            log.info((Object)("URLEncoder hack failed. Really nothing to worry about: " + t.getMessage()), t);
        }
    }

    public static void loadDefaultProperties() {
        try {
            InputStream in = GeneralUtil.class.getResourceAsStream("/com/atlassian/confluence/default.properties");
            Properties properties = new Properties();
            properties.load(in);
            versionNumber = properties.getProperty("version.number");
            buildDate = GeneralUtil.convertToDateWithEnglishLocale(properties.getProperty("build.date"));
            buildNumber = properties.getProperty("build.number");
            buildPartner = GeneralUtil.defaultPropertyCheck(properties.getProperty("build.partner"));
            buildExcludedLocale = GeneralUtil.defaultPropertyCheck(properties.getProperty("build.excluded.locale"));
        }
        catch (Throwable e) {
            Logger.getRootLogger().error((Object)"Error while trying to load the default properties!", e);
            throw new RuntimeException(e);
        }
    }

    private static String defaultPropertyCheck(String property) {
        if (property.startsWith("@") && property.endsWith("@")) {
            return null;
        }
        return property;
    }

    private static Date convertToDateWithEnglishLocale(String buildDateString) {
        if (buildDateString == null) {
            throw new IllegalArgumentException("parameter buildDateString may not be null.");
        }
        SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy", Locale.ENGLISH);
        formatter.setLenient(false);
        try {
            return formatter.parse(buildDateString);
        }
        catch (ParseException e) {
            log.info((Object)e.getMessage());
            return Calendar.getInstance(Locale.ENGLISH).getTime();
        }
    }

    private static FormatSettingsManager getFormatSettingsManager() {
        return (FormatSettingsManager)ContainerManager.getComponent((String)"formatSettingsManager");
    }

    public static String getStackTrace(Throwable t) {
        if (t == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String format(Number number) {
        String pattern = GeneralUtil.getFormatSettingsManager().getLongNumberFormat();
        if (number instanceof Double || number instanceof BigDecimal || number instanceof Float) {
            pattern = GeneralUtil.getFormatSettingsManager().getDecimalNumberFormat();
        }
        try {
            DecimalFormat format = new DecimalFormat(pattern);
            return format.format(number);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static DateFormatter getDateFormatter() {
        User user = AuthenticatedUserThreadLocal.getUser();
        FormatSettingsManager formatSettingsManager = (FormatSettingsManager)ContainerManager.getComponent((String)"formatSettingsManager");
        return userAccessor.getConfluenceUserPreferences(user).getDateFormatter(formatSettingsManager);
    }

    public static String format(Date date) {
        try {
            return GeneralUtil.getDateFormatter().format(date);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String format(String str) {
        return str != null ? str : "";
    }

    public static String format(Object obj) {
        try {
            if (obj instanceof Number) {
                return GeneralUtil.format((Number)obj);
            }
            if (obj instanceof Date) {
                return GeneralUtil.format((Date)obj);
            }
            if (obj instanceof String) {
                return GeneralUtil.format((String)obj);
            }
            return obj.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String formatDateTime(Date date) {
        try {
            return GeneralUtil.getDateFormatter().formatDateTime(date);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String formatTime(Date date) {
        try {
            return GeneralUtil.getDateFormatter().formatTime(date);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String formatBlogDate(Date date) {
        return GeneralUtil.getDateFormatter().formatBlogDate(date);
    }

    public static Date convertMailFormatDate(String date) throws ParseException {
        if (StringUtils.isBlank((String)date)) {
            return null;
        }
        return new MailDateFormat().parse(date);
    }

    public static Character convertToCharacter(Object obj) {
        if (obj instanceof Character) {
            return (Character)obj;
        }
        try {
            return new Character(obj.toString().charAt(0));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Integer convertToInteger(Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        try {
            DecimalFormat parseFormat = new DecimalFormat("###############");
            return new Integer(parseFormat.parse(obj.toString()).intValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Boolean convertToBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        try {
            return Boolean.valueOf(obj.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean convertToBoolean(Object bool, boolean defaultValue) {
        Boolean boolObj = GeneralUtil.convertToBoolean(bool);
        if (boolObj == null) {
            return defaultValue;
        }
        return boolObj;
    }

    public static String convertToString(Object obj) {
        try {
            String result = obj.toString();
            if (result.equals("")) {
                result = null;
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String completeUrlEncode(String url) {
        if (url == null) {
            return null;
        }
        try {
            return CompleteURLEncoder.encode(url, GeneralUtil.getCharacterEncoding());
        }
        catch (MalformedURLException e) {
            log.error((Object)"Error while trying to encode the URL!", (Throwable)e);
            return url;
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Error while trying to encode the URL!", (Throwable)e);
            return url;
        }
    }

    public static String urlEncode(String url) {
        if (url == null) {
            return null;
        }
        try {
            return URLEncoder.encode(url, GeneralUtil.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Error while trying to encode the URL!", (Throwable)e);
            return url;
        }
    }

    public static String urlDecode(String url) {
        if (url == null) {
            return null;
        }
        try {
            return URLDecoder.decode(url, GeneralUtil.getCharacterEncoding());
        }
        catch (Exception e) {
            log.error((Object)("Error while trying to decode url" + url), (Throwable)e);
            return url;
        }
    }

    public static boolean shouldUrlDecode(String str) {
        if (str == null) {
            return false;
        }
        return str.matches(".*%[a-zA-Z0-9]{2}.*") || str.indexOf("+") != -1;
    }

    public static String getPageUrl(VersionHistorySummary summary) {
        return "/pages/viewpage.action?pageId=" + summary.getId();
    }

    public static String getPageUrl(AbstractPage page) {
        if (page == null || page.getOriginalVersion() == null && page.getSpace() == null) {
            return "";
        }
        String title = page.getTitle();
        if (GeneralUtil.isSafeTitleForUrl(title) && page.isLatestVersion()) {
            return GeneralUtil.toDisplayUrl(page);
        }
        return GeneralUtil.getIdBasedPageUrl(page);
    }

    public static String getIdBasedPageUrl(AbstractPage page) {
        if (page == null) {
            return "";
        }
        return "/pages/viewpage.action?pageId=" + page.getId();
    }

    public static boolean isSafeTitleForUrl(String title) {
        return StringUtils.isNotEmpty((String)title) && title.length() < 150 && GeneralUtil.isAllAscii(title) && !GeneralUtil.hasFormattingCharacters(title) && title.indexOf("\"") == -1;
    }

    private static boolean hasFormattingCharacters(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return false;
        }
        if (".".equals(text)) {
            return true;
        }
        String[] illegalChars = new String[]{"+", "?", "%", "&"};
        for (int i = 0; i < illegalChars.length; ++i) {
            String illegalChar = illegalChars[i];
            if (text.indexOf(illegalChar) == -1) continue;
            return true;
        }
        return false;
    }

    private static String toDisplayUrl(AbstractPage page) {
        StringBuffer displayUrl = new StringBuffer("/display/");
        displayUrl.append(GeneralUtil.urlEncode(page.getSpace().getKey()));
        displayUrl.append("/");
        if ("blogpost".equals(page.getType()) && page.getCreationDate() != null) {
            displayUrl.append(new SimpleDateFormat("yyyy/MM/dd").format(page.getCreationDate()));
            displayUrl.append("/");
        }
        displayUrl.append(GeneralUtil.urlEncode(page.getTitle()));
        return displayUrl.toString();
    }

    public static String customGetPageUrl(AbstractPage page) {
        String pageUrl = GeneralUtil.getPageUrl(page);
        return GeneralUtil.appendAmpsandOrQuestionMark(pageUrl);
    }

    public static String appendAmpsandOrQuestionMark(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        if (str.indexOf("?") != -1) {
            return str + "&";
        }
        return str + "?";
    }

    public static String wordWrap(String str, int max) {
        if (StringUtils.isBlank((String)str)) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str);
        int nonSpaceChars = 0;
        for (int i = 0; i < sb.length(); ++i) {
            nonSpaceChars = Character.isWhitespace(sb.charAt(i)) ? 0 : ++nonSpaceChars;
            if (nonSpaceChars <= max) continue;
            nonSpaceChars = 0;
            sb.insert(i, " ");
            ++i;
        }
        return sb.toString().trim();
    }

    public static String highlight(String content, String searchwords) {
        if (StringUtils.isEmpty((String)content) || StringUtils.isEmpty((String)searchwords)) {
            return content;
        }
        StringTokenizer st = new StringTokenizer(searchwords, ", ");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("span") || token.equalsIgnoreCase("class") || token.equalsIgnoreCase("search") || token.equalsIgnoreCase("highlight")) continue;
            content = Pattern.compile("(" + token + ")", 2).matcher(content).replaceAll("<span class=\"search-highlight\">$0</span>");
        }
        return content;
    }

    public static String doubleUrlEncode(String s) {
        return GeneralUtil.urlEncode(GeneralUtil.urlEncode(s));
    }

    public static boolean isAllAscii(String s) {
        char[] sChars = s.toCharArray();
        for (int i = 0; i < sChars.length; ++i) {
            char sChar = sChars[i];
            if (sChar <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static boolean isAllLettersOrNumbers(String s) {
        char[] sChars = s.toCharArray();
        for (int i = 0; i < sChars.length; ++i) {
            char sChar = sChars[i];
            if (Character.isLetterOrDigit(sChar)) continue;
            return false;
        }
        return true;
    }

    public static String getVersionNumber() {
        return versionNumber;
    }

    public static Date getBuildDate() {
        return buildDate;
    }

    public static String getBuildDateString() {
        SimpleDateFormat format = new SimpleDateFormat("MMM dd, yyyy");
        format.setTimeZone(TimeZone.getDefault().getWrappedTimeZone());
        return format.format(buildDate);
    }

    public static String getBuildNumber() {
        return buildNumber;
    }

    public static String getBuildPartner() {
        return buildPartner;
    }

    public static String getBuildExcludedLocale() {
        return buildExcludedLocale;
    }

    public static Long getSystemStartupTime() {
        return systemStartupTime;
    }

    public static void setSystemStartupTime(Long systemStartupTime) {
        GeneralUtil.systemStartupTime = systemStartupTime;
    }

    public static boolean isLicenseExpired() {
        if (buildDate == null) {
            return false;
        }
        License license = LicenseManager.getInstance().getLicense("CONF");
        Date expiryDate = license.getExpiryDate();
        if (expiryDate != null) {
            return new Date().after(expiryDate);
        }
        return false;
    }

    public static String checkPartnerDetails(License license, String buildPartnerName) {
        if (license == null) {
            return ConfluenceActionSupport.getTextStatic("error.license.not.valid");
        }
        String partnerErrorCode = LicenseUtils.isPartnerDetailsValid((License)license, (String)buildPartnerName);
        if (partnerErrorCode.equals("partner not matching build partner name")) {
            return ConfluenceActionSupport.getTextStatic("license.error.invalidlicensekey.regional.license", new String[]{license.getPartnerName()});
        }
        if (partnerErrorCode.equals("License does not contain a partner name")) {
            return ConfluenceActionSupport.getTextStatic("license.error.invalidlicensekey.regional.installation", new String[]{buildPartnerName});
        }
        return null;
    }

    public static boolean hasTooManyUsers() {
        if (!ContainerManager.isContainerSetup()) {
            return false;
        }
        License license = LicenseManager.getInstance().getLicense("CONF");
        UserAccessor accessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        List activeUsers = accessor.getUsersWithConfluenceAccessAsList();
        int activeUsersCount = activeUsers.size();
        if (license == null) {
            return true;
        }
        return activeUsersCount > license.getUsers();
    }

    public static boolean stringSet(String str) {
        return str != null && str.length() > 0;
    }

    public static String formatLongTime(long time) {
        StringBuffer result = new StringBuffer();
        if (time > 3600000L) {
            time = GeneralUtil.scaleTime(time, 3600000L, result);
            result.append(":");
        }
        time = GeneralUtil.scaleTime(time, 60000L, result);
        result.append(":");
        time = GeneralUtil.scaleTime(time, 1000L, result);
        result.append(".").append(time);
        return result.toString();
    }

    private static long scaleTime(long time, long scale, StringBuffer buf) {
        long report = time / scale;
        time -= report * scale;
        String result = Long.toString(report);
        if (report < 10L) {
            result = "0" + result;
        }
        buf.append(result);
        return time;
    }

    public static String displayShortUrl(String url) {
        return GeneralUtil.displayShortUrl(url, 32);
    }

    public static String displayShortUrl(String url, int length) {
        if (StringUtils.isEmpty((String)url)) {
            return "";
        }
        if (UrlUtil.startsWithUrl((String)url)) {
            if (url.startsWith("http://")) {
                url = url.substring(7);
            }
            int indexOfGoogle = url.indexOf(".google.");
            int indexOfQuery = url.indexOf("q=");
            if (indexOfGoogle >= 0 && indexOfQuery >= 0) {
                url = GeneralUtil.extractGoogleUrl(url, indexOfQuery);
            }
        }
        if (url.length() < length) {
            return url;
        }
        return url.substring(0, length - 3) + "...";
    }

    public static String formatDateFull(Date date) {
        return DateFormat.getDateInstance(0).format(date);
    }

    public static boolean isSuperUser(User user) {
        return GeneralUtil.getUserAccessor().isSuperUser(user);
    }

    public static String getCharacterEncoding() {
        Settings globalSettings = GeneralUtil.getGlobalSettings();
        return globalSettings == null ? "UTF-8" : globalSettings.getDefaultEncoding();
    }

    @HtmlSafe
    public static String escapeXml(String stringToEscape) {
        return XMLUtils.escape((String)stringToEscape);
    }

    public static String escapeForJavascript(String s) {
        if (s == null) {
            return s;
        }
        s = s.replaceAll("\\\\", "\\\\\\\\");
        s = s.replaceAll("\\'", "\\\\\\'");
        s = s.replaceAll("\\\"", "\\\\\\\"");
        return s;
    }

    public static boolean isSetupComplete() {
        return BootstrapUtils.getBootstrapManager().isSetupComplete();
    }

    public static String maskEmail(String emailAddress) {
        if (emailAddress == null || "email.address.public".equals(GeneralUtil.getGlobalSettings().getEmailAddressVisibility())) {
            return emailAddress;
        }
        if ("email.address.private".equals(GeneralUtil.getGlobalSettings().getEmailAddressVisibility())) {
            return "hidden";
        }
        return GeneralUtil.alwaysMaskEmail(emailAddress);
    }

    public static String alwaysMaskEmail(String emailAddress) {
        StringBuffer buf = new StringBuffer(emailAddress.length() + 20);
        for (int i = 0; i < emailAddress.length(); ++i) {
            char c = emailAddress.charAt(i);
            if (c == '.') {
                buf.append(" dot ");
                continue;
            }
            if (c == '@') {
                buf.append(" at ");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String findAndMaskEmail(String text, User currentUser) {
        if (currentUser != null && userAccessor.hasMembership("confluence-administrators", currentUser.getName())) {
            return text;
        }
        if (StringUtils.isEmpty((String)text) || "email.address.public".equals(GeneralUtil.getGlobalSettings().getEmailAddressVisibility())) {
            return text;
        }
        Matcher matcher = EMAIL_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, GeneralUtil.maskEmail(matcher.group(0)));
        }
        if (sb.length() == 0) {
            return text;
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String escapeCDATA(String s) {
        if (s.indexOf("]]") < 0) {
            return s;
        }
        return s.replaceAll("\\]\\]", "]] ");
    }

    public static String unescapeCDATA(String s) {
        if (s.indexOf("]] ") < 0) {
            return s;
        }
        return s.replaceAll("\\]\\] ", "]]");
    }

    public static File createTempDirectoryInConfluenceTemp(String prefix) {
        Date date = new Date();
        String pattern = "_{0,date,MMddyyyy}_{1,time,HHmmss}";
        String uniqueRandomFileName = MessageFormat.format(pattern, date, date);
        return new File(BootstrapUtils.getBootstrapManager().getFilePathProperty("webwork.multipart.saveDir"), prefix + uniqueRandomFileName);
    }

    public static File createTempFile(String directory) {
        Date date = new Date();
        String pattern = "_{0,date,MMddyyyy}_{1,time,HHmmss}";
        String uniqueRandomFileName = MessageFormat.format(pattern, date, date);
        return new File(directory, uniqueRandomFileName);
    }

    public static String unescapeEntities(String str) {
        Pattern hexEntityPattern = Pattern.compile("&([a-fA-F0-9]+);");
        Pattern decimalEntityPattern = Pattern.compile("&#([0-9]+);");
        str = GeneralUtil.replaceNumericEntities(str, hexEntityPattern, 16);
        return GeneralUtil.replaceNumericEntities(str, decimalEntityPattern, 10);
    }

    private static String replaceNumericEntities(String str, Pattern pattern, int base) {
        Matcher matcher = pattern.matcher(str);
        StringBuffer buf = new StringBuffer(str.length());
        while (matcher.find()) {
            matcher.appendReplacement(buf, Character.toString((char)Integer.parseInt(matcher.group(1), base)));
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    public static String base64Decode(String s) {
        try {
            String s1 = s.replaceAll("_", "/");
            String s2 = s1.replaceAll("-", "+");
            byte[] sBytes = s2.getBytes();
            return new String(Base64.decodeBase64((byte[])sBytes), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"This Java installation doesn't support UTF-8. Call Mulder");
            return s;
        }
    }

    public static String base64Encode(String s) {
        try {
            byte[] sBytes = s.getBytes("UTF-8");
            return new String(Base64.encodeBase64((byte[])sBytes)).replaceAll("\\n", "").replaceAll("/", "_").replaceAll("\\+", "-").trim();
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"This Java installation doesn't support UTF-8. Call Mulder");
            return s;
        }
    }

    public static String hackSingleQuotes(String s) {
        if (StringUtils.isNotEmpty((String)s)) {
            return s.replaceAll("'", "' + '\\\\'' + '");
        }
        return s;
    }

    public static boolean isInLastDays(Date date, int maxDays) {
        if (date == null) {
            return false;
        }
        long tstamp = date.getTime();
        long t0 = System.currentTimeMillis();
        long dt = t0 - tstamp;
        long secs = dt / 1000L;
        long mins = secs / 60L;
        long hours = mins / 60L;
        long days = hours / 24L;
        return days < (long)maxDays;
    }

    public static String getRelativeTime(Date date) {
        if (date == null) {
            return "No timestamp.";
        }
        long tstamp = date.getTime();
        long t0 = System.currentTimeMillis();
        long dt = t0 - tstamp;
        long secs = dt / 1000L;
        long mins = secs / 60L;
        long hours = mins / 60L;
        long days = hours / 24L;
        if (days != 0L) {
            if (days == 1L) {
                return ConfluenceActionSupport.getTextStatic("one.day.ago");
            }
            return ConfluenceActionSupport.getTextStatic("x.days.ago", new Object[]{"" + days});
        }
        if ((hours -= days * 24L) != 0L) {
            if (hours == 1L) {
                return ConfluenceActionSupport.getTextStatic("one.hour.ago");
            }
            return ConfluenceActionSupport.getTextStatic("x.hours.ago", new Object[]{"" + hours});
        }
        if ((mins -= (days * 24L + hours) * 60L) != 0L) {
            if (mins == 1L) {
                return ConfluenceActionSupport.getTextStatic("one.min.ago");
            }
            return ConfluenceActionSupport.getTextStatic("x.mins.ago", new Object[]{"" + mins});
        }
        return ConfluenceActionSupport.getTextStatic("less.than.one.min");
    }

    public static String getFormatDateSimple(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("dd MMM");
        return df.format(date);
    }

    public static Cookie setCookie(String key, String value) {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        int cookieAge = 31104000;
        String path = request.getContextPath();
        if (StringUtils.isEmpty((String)path)) {
            path = "/";
        }
        return CookieFactory.getCookieHandler().setCookie(request, response, key, value, cookieAge, path);
    }

    public static String getCookieValue(String key) {
        HttpServletRequest request = ServletActionContext.getRequest();
        return CookieFactory.getCookieHandler().getCookieValue(request, key);
    }

    @HtmlSafe
    public static String htmlEncode(String text) {
        return PlainTextToHtmlConverter.encodeHtmlEntities(text);
    }

    public static boolean isGlobalAdministrator(Object notUsedAnyMore, User user) {
        log.info((Object)"Template uses deprecated GeneralUtil.isGlobalAdministrator. Replace with $permissionHelper.isGlobalAdministrator");
        return GeneralUtil.isSuperUser(user) || ((PermissionManager)ContainerManager.getComponent((String)"permissionManager")).hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public static String plain2html(String text) {
        return PlainTextToHtmlConverter.toHtml(text);
    }

    public static Properties getProperties(String resource, Class callingClass) {
        return PropertyUtils.getProperties((String)resource, (Class)callingClass);
    }

    public static Properties getPropertiesFromFile(File file) {
        return PropertyUtils.getPropertiesFromFile((File)file);
    }

    public static Properties getPropertiesFromStream(InputStream is) {
        return PropertyUtils.getPropertiesFromStream((InputStream)is);
    }

    public static void unzipFile(File zipFile, File dirToExtractTo) throws Exception {
        if (!zipFile.isFile()) {
            throw new IOException("Zip file doesn't exist or Confluence doesn't have read access to it. backupedFile=" + zipFile);
        }
        FileUnzipper fileUnzipper = new FileUnzipper(zipFile, dirToExtractTo);
        fileUnzipper.unzip();
    }

    public static void unzipUrl(URL zipUrl, File dirToExtractTo) throws Exception {
        UrlUnzipper urlUnzipper = new UrlUnzipper(zipUrl, dirToExtractTo);
        urlUnzipper.unzip();
    }

    private static String extractGoogleUrl(String url, int indexOfQuery) {
        try {
            int indexOfAmpersand = url.indexOf("&", indexOfQuery);
            String googleQueryPhrase = indexOfAmpersand > -1 ? url.substring(indexOfQuery + 2, indexOfAmpersand) : url.substring(indexOfQuery + 2);
            url = "Google: " + URLDecoder.decode(googleQueryPhrase);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    public static String getUploadFileTooLargeMessage(String errorMessage) {
        Pattern p = Pattern.compile("java\\.io\\.IOException: Content Length Error \\((\\p{Digit}+) > (\\p{Digit}+)\\)");
        Matcher m = p.matcher(errorMessage);
        if (m.matches()) {
            String attachmentSize = FileSize.format((long)Long.parseLong(m.group(1)));
            String maxAttachmentSize = FileSize.format((long)Long.parseLong(m.group(2)));
            return "Total upload size is too large (" + attachmentSize + "). Reduce total filesize to below " + maxAttachmentSize;
        }
        return errorMessage;
    }

    public static ResourceBundle getDefaultResourceBundle() {
        ConfluenceActionSupport action = new ConfluenceActionSupport();
        if (ContainerManager.isContainerSetup()) {
            ContainerManager.autowireComponent((Object)action);
        }
        return ResourceBundle.getBundle(ConfluenceActionSupport.class.getName(), action.getLocale(), Thread.currentThread().getContextClassLoader());
    }

    public static I18NBean getI18n() {
        return (I18NBean)ContainerManager.getComponent((String)"i18NBean");
    }

    public int arraySize(int[] array) {
        return array.length;
    }

    public static String escapeXMLCharacters(String input) {
        return input.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt");
    }

    public static String htmlEscapeQuotes(String input) {
        if (StringUtils.isEmpty((String)input)) {
            return "";
        }
        return PlainTextToHtmlConverter.encodeHtmlEntities(input.replaceAll("'", "\\\\'").replaceAll("\"", "\\\\\""));
    }

    public static List filterNulls(Collection in) {
        ArrayList l = new ArrayList();
        for (Object o : in) {
            if (o == null) continue;
            l.add(o);
        }
        return l;
    }

    public static String shortenString(String str, int max) {
        if (StringUtils.isNotBlank((String)str) && str.length() > max) {
            return str.substring(0, max) + "...";
        }
        return str;
    }

    public static String specialToLowerCase(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        boolean propertyIsSet = BootstrapUtils.getBootstrapManager().getApplicationConfig().getProperty((Object)"hibernate.database.lower_non_ascii_supported") != null;
        boolean lowerSupported = BootstrapUtils.getBootstrapManager().getApplicationConfig().getBooleanProperty((Object)"hibernate.database.lower_non_ascii_supported");
        if (propertyIsSet && !lowerSupported) {
            char[] chars = str.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] >= '\u0080') continue;
                chars[i] = Character.toLowerCase(chars[i]);
            }
            return new String(chars);
        }
        return str.toLowerCase();
    }

    public static String replaceConfluenceHomeConstant(String in, String confHome) {
        if (in == null) {
            return null;
        }
        StringBuffer prop = new StringBuffer(in);
        int length = "${confluenceHome}".length();
        int index = prop.indexOf("${confluenceHome}");
        while (index != -1) {
            prop.replace(index, index + length, confHome);
            index = prop.indexOf("${confluenceHome}");
        }
        return prop.toString();
    }

    public static Collection specialLowerCaseCollection(Collection collection) {
        ArrayList<String> lowerCollection = new ArrayList<String>();
        for (String string : collection) {
            lowerCollection.add(GeneralUtil.specialToLowerCase(string));
        }
        return lowerCollection;
    }

    public static List safeSubList(List list, int max) {
        if (list == null || list.size() < max) {
            return list;
        }
        return list.subList(0, max);
    }

    public static String summarise(String content) {
        return RendererUtil.summarise((String)content);
    }

    public static Summary makeSummary(String content) {
        return GeneralUtil.makeSummary(content, null);
    }

    public static Summary makeSummary(String content, String query) {
        Summary summary = null;
        try {
            String strippedContent = RendererUtil.stripBasicMarkup((String)content);
            strippedContent = strippedContent.replaceAll("&nbsp;", "\u00a0");
            if (strippedContent != null && !"".equals(strippedContent.trim())) {
                Summarizer s = (Summarizer)ContainerManager.getComponent((String)"summarizer");
                UtilTimerStack.push((String)"Summarizer.getSummary");
                summary = s.getSummary(strippedContent, query);
                UtilTimerStack.pop((String)"Summarizer.getSummary");
            }
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
        return summary;
    }

    public static UserAccessor getUserAccessor() {
        if (userAccessor == null) {
            userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        }
        return userAccessor;
    }

    public static void setUserAccessor(UserAccessor userAcc) {
        userAccessor = userAcc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageInfo getImageInfo(File pathToImage) {
        ImageInfo imageInfo;
        if (pathToImage == null) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(pathToImage);
            ImageInfo imageInfo2 = new ImageInfo();
            imageInfo2.setInput((InputStream)fis);
            imageInfo2.setDetermineImageNumber(true);
            imageInfo2.setCollectComments(true);
            imageInfo2.isValidImage();
            imageInfo = imageInfo2;
        }
        catch (FileNotFoundException e) {
            ImageInfo imageInfo3;
            try {
                log.error((Object)("Could not load image " + pathToImage));
                imageInfo3 = null;
            }
            catch (Throwable throwable) {
                IOUtils.close(fis);
                throw throwable;
            }
            IOUtils.close(fis);
            return imageInfo3;
        }
        IOUtils.close(fis);
        return imageInfo;
    }

    public static String getNiceDuration(int minutes, int seconds) {
        String result = "";
        if (minutes > 0) {
            result = result + minutes + " minute" + (minutes > 1 ? "s" : "") + " ";
        }
        if (seconds > 0) {
            result = result + seconds + " second" + (seconds > 1 ? "s" : "");
        }
        return result;
    }

    public static ConfluenceActionSupport newWiredConfluenceActionSupport() {
        ConfluenceActionSupport dummy = new ConfluenceActionSupport();
        if (ContainerManager.isContainerSetup()) {
            ContainerManager.autowireComponent((Object)dummy);
        }
        if (BootstrapUtils.getBootstrapManager() != null && BootstrapUtils.getBootstrapContext() != null && !BootstrapUtils.getBootstrapManager().isSetupComplete()) {
            dummy = new ConfluenceActionSupport(){

                public Locale getLocale() {
                    ApplicationConfiguration applicationConfig = (ApplicationConfiguration)BootstrapUtils.getBootstrapContext().getBean("applicationConfig");
                    String localeString = (String)applicationConfig.getProperty((Object)"confluence.setup.locale");
                    if (localeString != null) {
                        return new DefaultLocaleManager().toLocale(localeString);
                    }
                    return LocaleManager.DEFAULT_LOCALE;
                }
            };
            dummy.setLanguageManager((LanguageManager)BootstrapUtils.getBootstrapContext().getBean("languageManager"));
            dummy.setI18NBeanFactory((I18NBeanFactory)BootstrapUtils.getBootstrapContext().getBean("i18NBeanFactory"));
        }
        return dummy;
    }

    public static void profilePush(String s) {
        UtilTimerStack.push((String)s);
    }

    public static void profilePop(String s) {
        UtilTimerStack.pop((String)s);
    }

    public static String lookupDomainName(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String port = "";
        if (!GeneralUtil.isStandardPort(request.getScheme(), request.getServerPort())) {
            port = ":" + request.getServerPort();
        }
        return request.getScheme() + "://" + request.getServerName() + port + request.getContextPath();
    }

    private static boolean isStandardPort(String scheme, int port) {
        if (scheme.equalsIgnoreCase("http") && port == 80) {
            return true;
        }
        return scheme.equalsIgnoreCase("https") && port == 443;
    }

    public static Settings getGlobalSettings() {
        if (ContainerManager.isContainerSetup()) {
            SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
            return settingsManager.getGlobalSettings();
        }
        return null;
    }

    public static String personalSpaceUrl(String contextPath, String username) {
        return contextPath + "/display/~" + GeneralUtil.doubleUrlEncode(username);
    }

    public static String getDefaultFontFamily() {
        FontManager fontManager = (FontManager)ContainerManager.getComponent((String)"fontManager");
        String installedFont = fontManager.getCurrentFont();
        if (StringUtils.isNotEmpty((String)installedFont)) {
            return installedFont;
        }
        return "Verdana";
    }

    public long getPercentage(long numerator, long denom) {
        return new MathBean().getPercentage(numerator, denom);
    }

    public long subtract(long a, long b) {
        return a - b;
    }

    public long getPercentage(String numeratorAsString, String denomAsString) {
        long denom;
        long numerator;
        try {
            numerator = Long.parseLong(numeratorAsString);
            denom = Long.parseLong(denomAsString);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
        return this.getPercentage(numerator, denom);
    }

    public long subtract(String firstOperandAsString, String secondOperandAsString) {
        long secondOperand;
        long firstOperand;
        try {
            firstOperand = Long.parseLong(firstOperandAsString);
            secondOperand = Long.parseLong(secondOperandAsString);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
        return this.subtract(firstOperand, secondOperand);
    }

    public static String getConfluenceTempDirectoryPath() {
        String tempDirPath = ((DefaultBootstrapManager)BootstrapUtils.getBootstrapManager()).getConfluenceHome() + File.separator + "temp";
        File tempDir = new File(tempDirPath);
        if (!tempDir.exists() && !tempDir.mkdir()) {
            throw new RuntimeException("Could not create temp directory inside Confluence home.");
        }
        return tempDirPath;
    }

    public static File getConfluenceTempDirectory() {
        return new File(GeneralUtil.getConfluenceTempDirectoryPath());
    }

    public static String[] splitCommaDelimitedString(String escapedNames) {
        if (StringUtils.isEmpty((String)escapedNames)) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer currentName = new StringBuffer();
        int i = 0;
        while (i < escapedNames.length()) {
            char c;
            if ((c = escapedNames.charAt(i++)) == '\\') {
                currentName.append(escapedNames.charAt(i++));
                continue;
            }
            if (c != ',') {
                currentName.append(c);
                continue;
            }
            result.add(currentName.toString().trim());
            currentName = new StringBuffer();
        }
        if (!StringUtils.isEmpty((String)currentName.toString())) {
            result.add(currentName.toString().trim());
        }
        return result.toArray(new String[result.size()]);
    }

    public static List escapeCommas(List toEscape) {
        ArrayList<String> result = new ArrayList<String>(toEscape.size());
        for (int i = 0; i < toEscape.size(); ++i) {
            result.add(GeneralUtil.escapeCommas((String)toEscape.get(i)));
        }
        return result;
    }

    public static String escapeCommas(String toEscape) {
        if (toEscape == null) {
            return null;
        }
        if (toEscape.indexOf("\\") < 0 && toEscape.indexOf(",") < 0) {
            return toEscape;
        }
        StringBuffer sb = new StringBuffer(toEscape.length() + 5);
        for (int i = 0; i < toEscape.length(); ++i) {
            if (toEscape.charAt(i) == ',') {
                sb.append("\\,");
                continue;
            }
            if (toEscape.charAt(i) == '\\') {
                sb.append("\\\\");
                continue;
            }
            sb.append(toEscape.charAt(i));
        }
        return sb.toString();
    }

    public static String constrainLength(String s, int length) {
        if (s != null && s.length() > length) {
            return s.substring(0, length);
        }
        return s;
    }

    public static boolean isOutgoingMailConfigured() {
        try {
            return MailFactory.getServerManager().getSmtpMailServers().size() > 0;
        }
        catch (MailException e) {
            log.error((Object)("Error retrieving SMTP mailservers: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public static boolean isEditorAjaxEnabled() {
        return System.getProperty("confluence.editor.ajax.disable") == null;
    }

    public static Map convertBeanToMap(Object bean) {
        ReflectiveOperationException exception;
        if (bean == null) {
            return Collections.EMPTY_MAP;
        }
        try {
            Map beanMap = BeanUtils.describe((Object)bean);
            beanMap.remove("class");
            return beanMap;
        }
        catch (InvocationTargetException ex) {
            exception = ex;
        }
        catch (NoSuchMethodException ex) {
            exception = ex;
        }
        catch (IllegalAccessException ex) {
            exception = ex;
        }
        log.warn((Object)"Exception while converting an information bean to a Map.", (Throwable)exception);
        return Collections.EMPTY_MAP;
    }

    public static Map prefixAllMapKeys(String prefix, Map map) {
        if (StringUtils.isBlank((String)prefix)) {
            return map;
        }
        if (map == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap prefixedMap = new HashMap(map.size());
        String prefixPoint = prefix + ".";
        for (Object key : map.keySet()) {
            if (key instanceof String) {
                String keyStr = (String)key;
                String prefixedKeyStr = prefixPoint + keyStr;
                prefixedMap.put(prefixedKeyStr, map.get(keyStr));
                continue;
            }
            prefixedMap.put((String)key, map.get(key));
        }
        return prefixedMap;
    }

    public static boolean isDefaultUserProfilePicture(String username) {
        ProfilePictureInfo info = userAccessor.getUserProfilePicture(username);
        return info == null || info.isDefault();
    }

    static {
        EMAIL_PATTERN = Pattern.compile(EMAIL_PATTERN_STRING);
        GeneralUtil.hackUrlEncoder();
    }
}

