/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Map;

public class JiraIconMappingManager {
    BandanaManager bandanaManager;

    public Map getIconMappings() {
        Map iconMappings = (Map)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "atlassian.confluence.jira.icon.mappings");
        if (iconMappings == null) {
            iconMappings = this.getDefaults();
        }
        return iconMappings;
    }

    public void addIconMapping(String jiraEntity, String iconFileName) {
        if (!TextUtils.stringSet((String)jiraEntity)) {
            return;
        }
        Map iconMappings = this.getIconMappings();
        iconMappings.put(jiraEntity, iconFileName);
        this.updateIconMappings(iconMappings);
    }

    public void removeIconMapping(String jiraEntity) {
        Map iconMappings = this.getIconMappings();
        iconMappings.remove(jiraEntity);
        this.updateIconMappings(iconMappings);
    }

    public void updateIconMappings(Map iconMappings) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "atlassian.confluence.jira.icon.mappings", (Object)iconMappings);
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public boolean hasIconMapping(String jiraEntity) {
        if (TextUtils.stringSet((String)jiraEntity)) {
            return this.getIconMappings().containsKey(jiraEntity);
        }
        return false;
    }

    public String getIconFileName(String jiraEntity) {
        if (TextUtils.stringSet((String)jiraEntity)) {
            return (String)this.getIconMappings().get(jiraEntity);
        }
        return null;
    }

    private Map getDefaults() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Bug", "bug.gif");
        map.put("New Feature", "newfeature.gif");
        map.put("Task", "task.gif");
        map.put("Sub-task", "issue_subtask.gif");
        map.put("Improvement", "improvement.gif");
        map.put("Blocker", "priority_blocker.gif");
        map.put("Critical", "priority_critical.gif");
        map.put("Major", "priority_major.gif");
        map.put("Minor", "priority_minor.gif");
        map.put("Trivial", "priority_trivial.gif");
        map.put("Assigned", "status_assigned.gif");
        map.put("Closed", "status_closed.gif");
        map.put("In Progress", "status_inprogress.gif");
        map.put("Need Info", "status_needinfo.gif");
        map.put("Open", "status_open.gif");
        map.put("Reopened", "status_reopened.gif");
        map.put("Resolved", "status_resolved.gif");
        map.put("Unassigned", "status_unassigned.gif");
        return map;
    }
}

