/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.core.actions.StylesheetAction;
import com.atlassian.confluence.plugin.descriptor.ThemeModuleDescriptor;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.opensymphony.oscache.web.ServletCacheAdministrator;
import com.opensymphony.webwork.ServletActionContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.log4j.Category;

public class LayoutHelper {
    public static final String TEMPLATE_PATH = "velocity";
    protected static final String FS = System.getProperty("file.separator");
    public static final String THEME_ICON = "themeicon.gif";
    public static final Category log = Category.getInstance(LayoutHelper.class);
    public static final String GLOBAL_CONFIGPATH = "global-config-path";
    public static final String SPACE_CONFIGPATH = "space-config-path";
    private ThemeManager themeManager;
    private boolean isGlobal = true;
    private static final String[] BUTTON_VALUES = new String[]{"global", "custom", "theme"};
    public static final List BUTTON_VALUE_LIST = Collections.unmodifiableList(Arrays.asList(BUTTON_VALUES));

    public static void flushThemeComponents(String spaceKey) {
        ServletCacheAdministrator admin = ServletCacheAdministrator.getInstance((ServletContext)ServletActionContext.getServletContext());
        admin.getAppScopeCache(ServletActionContext.getServletContext()).flushPattern(".css");
        StylesheetAction.getLastModifiedHandlerForSpace(spaceKey).modified();
    }

    public ThemeModuleDescriptor findThemeDescriptor(String moduleCompleteKey) {
        for (ThemeModuleDescriptor descriptor : this.themeManager.getAvailableThemeDescriptors()) {
            if (!descriptor.getCompleteKey().equals(moduleCompleteKey)) continue;
            return descriptor;
        }
        return null;
    }

    public boolean hasIcon(ThemeModuleDescriptor descriptor) {
        List list = descriptor.getResourceDescriptors("download");
        for (int i = 0; i < list.size(); ++i) {
            ResourceDescriptor resourceDescriptor = (ResourceDescriptor)list.get(i);
            if (!THEME_ICON.equals(resourceDescriptor.getName())) continue;
            return true;
        }
        return false;
    }

    public String getConfigPath(ThemeModuleDescriptor descriptor, String configPath) {
        if (descriptor.getParams().containsKey(configPath)) {
            return (String)descriptor.getParams().get(configPath);
        }
        return null;
    }

    public List getColourSchemeTypes() {
        return BUTTON_VALUE_LIST;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean global) {
        this.isGlobal = global;
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public static String getFullTemplatePath() {
        BootstrapManager bootstrapManager = (BootstrapManager)BootstrapUtils.getBootstrapManager();
        return bootstrapManager.getConfluenceHome() + System.getProperty("file.separator") + TEMPLATE_PATH;
    }
}

