/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListUtils {
    public static List getFirstMatchingObjectsFrom(Iterator it, List criteria, int maxSize) {
        ArrayList targetList = new ArrayList(maxSize > 100 ? 100 : maxSize);
        while (it.hasNext() && targetList.size() < maxSize) {
            Object o = it.next();
            if (!ListUtils.shouldInclude(criteria, targetList, o)) continue;
            targetList.add(o);
        }
        return targetList;
    }

    public static List getFirstMatchingObjectsFrom(Iterator it, Criterion criterion, int maxSize) {
        ArrayList targetList = new ArrayList(maxSize > 100 ? 100 : maxSize);
        while (it.hasNext() && targetList.size() < maxSize) {
            Object o = it.next();
            if (!criterion.test(targetList, o)) continue;
            targetList.add(o);
        }
        return targetList;
    }

    private static boolean shouldInclude(List criteria, List alreadyIncluded, Object o) {
        for (Criterion criterion : criteria) {
            if (criterion.test(alreadyIncluded, o)) continue;
            return false;
        }
        return true;
    }

    public static interface Criterion {
        public boolean test(List var1, Object var2);
    }
}

