/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.core.filters.AbstractFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public class LoggingContextFilter
extends AbstractFilter {
    private static Logger log = Logger.getLogger(LoggingContextFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String userName = request.getRemoteUser();
        try {
            MDC.put((String)"url", (Object)request.getRequestURI());
            MDC.put((String)"userName", (Object)(userName == null ? "anonymous" : userName));
        }
        catch (Exception ex) {
            log.error((Object)"Error adding logging context", (Throwable)ex);
        }
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            MDC.remove((String)"url");
            MDC.remove((String)"userName");
        }
    }
}

