/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.confluence.util.PatternLayoutWithStackTrace;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.MDC;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public class PatternLayoutWithContext
extends PatternLayoutWithStackTrace {
    private static final String CONTEXT_LEADER = " -- ";
    private static final String MDC_ENTRY_SEPARATOR = " | ";
    private static final String MDC_KEY_VALUE_SEPARATOR = ": ";

    void appendBeforeStackTrace(StringBuffer result, LoggingEvent event) {
        if (!event.getLevel().isGreaterOrEqual(Priority.ERROR) && event.getThrowableInformation() == null) {
            return;
        }
        if (MDC.getContext() == null || MDC.getContext().isEmpty()) {
            return;
        }
        result.append(CONTEXT_LEADER);
        Hashtable context = MDC.getContext();
        Iterator entryIterator = context.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            result.append(entry.getKey()).append(MDC_KEY_VALUE_SEPARATOR).append(entry.getValue());
            if (!entryIterator.hasNext()) continue;
            result.append(MDC_ENTRY_SEPARATOR);
        }
        result.append("\n");
    }
}

