/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.opensymphony.util.TextUtils;

public class QuickPageRenderBean {
    private PageManager pageManager;
    private WikiStyleRenderer wikiStyleRenderer;
    private static final String PAGE_NOT_FOUND = "<span class=\"error\"><span class=\"errorMessage\">Page not found</span></span>";

    public boolean canRender(String spaceKey, String pageTitle) {
        return TextUtils.stringSet((String)spaceKey) && this.pageManager.getPage(spaceKey, pageTitle) != null;
    }

    public boolean pageExists(String spaceKey, String title) {
        return this.pageManager.getPage(spaceKey, title) != null;
    }

    public boolean pageExists(long pageId) {
        return this.pageManager.getPage(pageId) != null;
    }

    public String render(String spaceKey, String pageTitle) {
        if (!TextUtils.stringSet((String)spaceKey)) {
            return "";
        }
        Page p = this.pageManager.getPage(spaceKey, pageTitle);
        if (p == null) {
            return PAGE_NOT_FOUND;
        }
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)p.toPageContext(), p.getContent());
    }

    public String render(long pageId) {
        Page p = this.pageManager.getPage(pageId);
        if (p == null) {
            return PAGE_NOT_FOUND;
        }
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)p.toPageContext(), p.getContent());
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }
}

