/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.filters.AbstractFilter;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class UserThreadLocalFilter
extends AbstractFilter {
    protected UserAccessor userAccessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean alreadyFiltered = false;
        try {
            if (servletRequest instanceof HttpServletRequest && BootstrapUtils.getBootstrapManager().isSetupComplete()) {
                User user = this.getUserFromRequest(servletRequest);
                User existingUser = AuthenticatedUserThreadLocal.getUser();
                if (existingUser != null && existingUser.equals(user)) {
                    alreadyFiltered = true;
                }
                AuthenticatedUserThreadLocal.setUser(user);
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            if (!alreadyFiltered) {
                AuthenticatedUserThreadLocal.setUser(null);
            }
        }
    }

    private User getUserFromRequest(ServletRequest servletRequest) {
        String username = ((HttpServletRequest)servletRequest).getRemoteUser();
        if (!TextUtils.stringSet((String)username)) {
            return null;
        }
        return this.getUserAccessor().getUser(username);
    }

    protected UserAccessor getUserAccessor() {
        if (this.userAccessor == null) {
            this.userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        }
        return this.userAccessor;
    }
}

