/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.actions;

import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import java.util.ArrayList;
import java.util.List;

public class PermissionSetter {
    private SpacePermissionManager spacePermissionManager;
    private Space space;
    private boolean registeredCanView;
    private boolean anonymousCanView;
    private boolean registeredCanEdit;
    private boolean anonymousCanEdit;
    public static final List VIEW_SPACE_PERMISSIONS = new ArrayList();
    public static final List EDIT_SPACE_PERMISSIONS = new ArrayList();

    public void execute() {
        if (this.registeredCanView) {
            for (String permissionType : VIEW_SPACE_PERMISSIONS) {
                this.spacePermissionManager.savePermission(new SpacePermission(permissionType, this.space, "confluence-users", null));
            }
        }
        if (this.anonymousCanView) {
            for (String permissionType : VIEW_SPACE_PERMISSIONS) {
                this.spacePermissionManager.savePermission(new SpacePermission(permissionType, this.space, null, null));
            }
        }
        if (this.registeredCanEdit) {
            for (String permissionType : EDIT_SPACE_PERMISSIONS) {
                this.spacePermissionManager.savePermission(new SpacePermission(permissionType, this.space, "confluence-users", null));
            }
        }
        if (this.anonymousCanEdit) {
            for (String permissionType : EDIT_SPACE_PERMISSIONS) {
                this.spacePermissionManager.savePermission(new SpacePermission(permissionType, this.space, null, null));
            }
        }
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    public boolean isRegisteredCanView() {
        return this.registeredCanView;
    }

    public void setRegisteredCanView(boolean registeredCanView) {
        this.registeredCanView = registeredCanView;
    }

    public boolean isAnonymousCanView() {
        return this.anonymousCanView;
    }

    public void setAnonymousCanView(boolean anonymousCanView) {
        this.anonymousCanView = anonymousCanView;
    }

    public boolean isRegisteredCanEdit() {
        return this.registeredCanEdit;
    }

    public void setRegisteredCanEdit(boolean registeredCanEdit) {
        this.registeredCanEdit = registeredCanEdit;
    }

    public boolean isAnonymousCanEdit() {
        return this.anonymousCanEdit;
    }

    public void setAnonymousCanEdit(boolean anonymousCanEdit) {
        this.anonymousCanEdit = anonymousCanEdit;
    }

    static {
        VIEW_SPACE_PERMISSIONS.add("VIEWSPACE");
        VIEW_SPACE_PERMISSIONS.add("COMMENT");
        EDIT_SPACE_PERMISSIONS.add("EDITSPACE");
        EDIT_SPACE_PERMISSIONS.add("CREATEATTACHMENT");
        EDIT_SPACE_PERMISSIONS.add("EDITBLOG");
        EDIT_SPACE_PERMISSIONS.add("EXPORTPAGE");
        EDIT_SPACE_PERMISSIONS.add("EXPORTSPACE");
    }
}

