/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.breadcrumbs;

import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.util.breadcrumbs.AbstractBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.Breadcrumb;
import com.atlassian.confluence.util.breadcrumbs.SpaceBreadcrumb;
import java.util.ArrayList;
import java.util.List;

public class BlogPostBreadcrumb
extends AbstractBreadcrumb {
    private BlogPost blogPost;

    public BlogPostBreadcrumb(BlogPost blogPost) {
        super(blogPost.getTitle(), blogPost.getUrlPath());
        this.blogPost = blogPost;
    }

    protected BlogPostBreadcrumb(String title, String target) {
        super(title, target);
    }

    protected List getMyCrumbs() {
        ArrayList<BlogPostBreadcrumb> breadcrumbs = new ArrayList<BlogPostBreadcrumb>();
        String datePath = this.blogPost.getDatePath();
        String[] postingDateParts = datePath.split("/");
        String postingYear = postingDateParts[0];
        String postingMonthNumeric = postingDateParts[1];
        String postingDayOfMonth = postingDateParts[2];
        String targetBase = "/display/" + this.blogPost.getSpaceKey() + "/";
        String monthTarget = targetBase + postingYear + "/" + postingMonthNumeric;
        String dayOfMonthTarget = targetBase + datePath;
        breadcrumbs.add(new BlogPostBreadcrumb(postingYear, null));
        breadcrumbs.add(new BlogPostBreadcrumb(this.blogPost.getPostingMonth(), monthTarget));
        breadcrumbs.add(new BlogPostBreadcrumb(postingDayOfMonth, dayOfMonthTarget));
        breadcrumbs.add(this);
        return breadcrumbs;
    }

    public Breadcrumb getParent() {
        return new SpaceBreadcrumb(this.blogPost.getSpace());
    }
}

