/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.breadcrumbs;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.breadcrumbs.AbstractSpaceBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.Breadcrumb;
import com.atlassian.confluence.util.breadcrumbs.DashboardBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.PeopleBreadcrumb;

public class SpaceBreadcrumb
extends AbstractSpaceBreadcrumb {
    public SpaceBreadcrumb(Space space) {
        super(space);
        if (space != null) {
            this.title = space.getName();
            this.target = this.getSpaceUrl(space);
        } else {
            this.title = "space-undefined";
        }
    }

    private String getSpaceUrl(Space space) {
        if (space.isPersonal()) {
            return "/display/~" + GeneralUtil.doubleUrlEncode(space.getCreatorName());
        }
        return space.getUrlPath();
    }

    protected Breadcrumb getParent() {
        if (this.space != null && this.space.isPersonal()) {
            return PeopleBreadcrumb.getInstance();
        }
        return DashboardBreadcrumb.getInstance();
    }
}

