/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.http.httpclient;

import com.atlassian.confluence.util.http.HttpRequest;
import com.atlassian.confluence.util.http.HttpResponse;
import com.atlassian.confluence.util.http.SizeLimitedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpMethod;

public class HttpClientHttpResponse
implements HttpResponse {
    private HttpRequest request;
    private HttpMethod method;

    public HttpClientHttpResponse(HttpRequest httpRequest, HttpMethod method) {
        this.request = httpRequest;
        this.method = method;
    }

    public boolean isCached() {
        return false;
    }

    public boolean isFailed() {
        return this.method == null || this.method.getStatusCode() < 200 || this.method.getStatusCode() > 299;
    }

    public boolean isNotFound() {
        return this.method.getStatusCode() == 404;
    }

    public boolean isNotPermitted() {
        return this.method.getStatusCode() == 403 || this.method.getStatusCode() == 401;
    }

    public InputStream getResponse() throws IOException {
        if (this.request.getMaximumSize() > 0) {
            return new SizeLimitedInputStream(this.method.getResponseBodyAsStream(), this.request.getMaximumSize());
        }
        return this.method.getResponseBodyAsStream();
    }

    public String getContentType() {
        return this.method.getResponseHeader("Content-type").toString();
    }

    public String getStatusMessage() {
        return this.method.getStatusText();
    }

    public int getStatusCode() {
        return this.method.getStatusCode();
    }

    public void finish() {
        this.method.releaseConnection();
    }
}

