/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.http.httpclient;

import com.atlassian.confluence.security.trust.TrustedToken;
import com.atlassian.confluence.security.trust.TrustedTokenFactory;
import com.atlassian.confluence.util.http.httpclient.HttpClientAuthenticator;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class TrustedTokenAuthenticator
extends HttpClientAuthenticator {
    private TrustedTokenFactory trustedTokenFactory;

    public TrustedTokenAuthenticator(TrustedTokenFactory trustedTokenFactory) {
        this.trustedTokenFactory = trustedTokenFactory;
    }

    public HttpMethod makeMethod(HttpClient client, String url) {
        GetMethod method = new GetMethod(url);
        TrustedToken token = this.trustedTokenFactory.getToken();
        if (token != null) {
            method.setRequestHeader("X-Seraph-Trusted-App-ID", token.getApplicationId());
            method.setRequestHeader("X-Seraph-Trusted-App-Key", token.getEncodedKey());
            method.setRequestHeader("X-Seraph-Trusted-App-Cert", token.getEncodedToken());
        }
        return method;
    }

    public TrustedConnectionStatus getTrustedConnectionStatus(HttpMethod httpMethod) {
        if (!httpMethod.hasBeenUsed()) {
            throw new IllegalStateException("Method has not been executed");
        }
        if (!TrustedTokenAuthenticator.isTrustedConnectionRequest(httpMethod)) {
            return null;
        }
        return this.buildStatus(httpMethod);
    }

    private static boolean isTrustedConnectionRequest(HttpMethod method) {
        return method.getRequestHeader("X-Seraph-Trusted-App-ID") != null;
    }

    private TrustedConnectionStatus buildStatus(HttpMethod httpMethod) {
        boolean trustSupported;
        Header[] statusHeaders = httpMethod.getResponseHeaders("X-Seraph-Trusted-App-Status");
        boolean bl = trustSupported = statusHeaders != null && statusHeaders.length != 0;
        if (!trustSupported) {
            return TrustedConnectionStatus.UNSUPPORTED;
        }
        Header[] headers = httpMethod.getResponseHeaders("X-Seraph-Trusted-App-Error");
        if (headers == null || headers.length == 0) {
            return TrustedConnectionStatus.SUCCESS;
        }
        TrustedConnectionStatusBuilder builder = new TrustedConnectionStatusBuilder();
        for (int x = 0; x < headers.length; ++x) {
            builder.addTrustedConnectionError(headers[x].getValue());
        }
        return builder.getStatus();
    }

    public static final class TrustedConnectionStatus {
        public static final TrustedConnectionStatus UNSUPPORTED = new TrustedConnectionStatus(false, false, false, Collections.EMPTY_LIST, false);
        public static final TrustedConnectionStatus SUCCESS = new TrustedConnectionStatus(true, true, false, Collections.EMPTY_LIST, true);
        private final boolean userRecognized;
        private final boolean appRecognized;
        private final boolean trustedConnectionError;
        private final List trustedConnectionErrors;
        private final boolean trustSupported;

        private TrustedConnectionStatus(boolean userRecognized, boolean appRecognized, boolean trustedConnectionError, List trustedConnectionErrors, boolean trustSupported) {
            this.userRecognized = userRecognized;
            this.appRecognized = appRecognized;
            this.trustedConnectionError = trustedConnectionError;
            this.trustedConnectionErrors = Collections.unmodifiableList(new LinkedList(trustedConnectionErrors));
            this.trustSupported = trustSupported;
        }

        public boolean isUserRecognized() {
            return this.userRecognized;
        }

        public boolean isAppRecognized() {
            return this.appRecognized;
        }

        public boolean isTrustedConnectionError() {
            return this.trustedConnectionError;
        }

        public List getTrustedConnectionErrors() {
            return this.trustedConnectionErrors;
        }

        public boolean isTrustSupported() {
            return this.trustSupported;
        }

        public String toString() {
            if (!this.trustSupported) {
                return "Trusted connection not supported";
            }
            if (!this.trustedConnectionError) {
                return "Trusted connection successful";
            }
            return "Trusted connection errors: " + this.trustedConnectionErrors;
        }
    }

    private static class TrustedConnectionStatusBuilder {
        private final List trustedConnectionErrors = new LinkedList();
        private static final String UNRECOGNIZED_APP = "Unrecognized application";
        private static final String UNRECOGNIZED_USER = "Unrecognized user";

        private TrustedConnectionStatusBuilder() {
        }

        public TrustedConnectionStatusBuilder addTrustedConnectionError(String error) {
            this.trustedConnectionErrors.add(error);
            return this;
        }

        public TrustedConnectionStatus getStatus() {
            if (this.trustedConnectionErrors.isEmpty()) {
                return TrustedConnectionStatus.SUCCESS;
            }
            boolean appRecognized = !this.trustedConnectionErrors.contains(UNRECOGNIZED_APP);
            boolean userRecognized = appRecognized && !this.trustedConnectionErrors.contains(UNRECOGNIZED_USER);
            return new TrustedConnectionStatus(userRecognized, appRecognized, true, this.trustedConnectionErrors, true);
        }
    }
}

